//+------------------------------------------------------------------+
//|                                                     GridTkEx.mqh |
//|                                                   Enrico Lambino |
//|                                     www.mql5.com/en/users/iceron |
//+------------------------------------------------------------------+
#property copyright "Enrico Lambino"
#property link "http://www.mql5.com"
#property strict
#include "GridTk.mqh"

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CGridTkEx: public CGridTk
{
 protected:
  bool Grid(CWnd *control, int row, int column, int rowspan, int colspan);

 public:
  bool SetGridConstraints(CWnd *control, int row, int column, int rowspan, int colspan);
  bool SetGridConstraints(CWnd &control, int row, int column, int rowspan, int colspan);
};

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CGridTkEx::SetGridConstraints(CWnd *control, int row, int column, int rowspan = 1, int colspan = 1)
{
  CGridConstraints *constraints = new CGridConstraints(control, row, column, rowspan, colspan);
  if(!CheckPointer(constraints))
    return (false);
  if(!m_constraints.Add(constraints))
    return (false);
  return true;
}

bool CGridTkEx::SetGridConstraints(CWnd &control, int row, int column, int rowspan = 1, int colspan = 1)
{
  return SetGridConstraints(&control, row, column, rowspan, colspan);
}