//+------------------------------------------------------------------+
//|                                                SQLiteCommand.mqh |
//|                                             Copyright GF1D, 2010 |
//|                                             garf1eldhome@mail.ru |
//+------------------------------------------------------------------+
#property copyright "GF1D, 2010"
#property link      "garf1eldhome@mail.ru"

#include "..\Base\DbCommand.mqh"
#include "SQLiteParameterList.mqh"
#include "SQLiteDataReader.mqh"
//--------------------------------------------------------------------
/// \brief  \~english Represents an SQL statement or stored procedure to execute against an SQLite data source
class CSQLiteCommand : public CDbCommand
  {
protected:
   virtual CDbParameterList *CreateParameters() { return new CSQLiteParameterList(); }
   virtual CDbDataReader *CreateReader() { return new CSQLiteDataReader(); }

public:
   /// \brief  \~english constructor
                     CSQLiteCommand();
  };
//--------------------------------------------------------------------
CSQLiteCommand::CSQLiteCommand()
  {
   MqlTypeName("CSQLiteCommand");
   CreateClrObject("System.Data.SQLite","System.Data.SQLite.SQLiteCommand");
  }
//+------------------------------------------------------------------+
