//+------------------------------------------------------------------+
//|                                      EasyXmlErrorDescription.mqh |
//|                                  Copyright 2013, Paul van Hemmen |
//|                                          http://www.vanhemmen.de |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, Paul van Hemmen"
#property link      "http://www.vanhemmen.de"

#define EASYXML_ERR_CONNECTION_ATTEMPT      1
#define EASYXML_ERR_CONNECTION_OPEN         2
#define EASYXML_ERR_CONNECTION_URL          3
#define EASYXML_ERR_CONNECTION_FILEOPEN     4
#define EASYXML_ERR_CONNECTION_EMPTYSTREAM  5
#define EASYXML_INVALID_PROLOG              6
#define EASYXML_INVALID_COMMENT             7
#define EASYXML_INVALID_OPENTAG_START       8
#define EASYXML_INVALID_OPENTAG_CLOSE       9
#define EASYXML_INVALID_CLOSETAG            10
#define EASYXML_NO_CLOSETAG                 11
#define EASYXML_INVALID_CDATA               12
#define EASYXML_INVALID_ATTRIBUTE           13
#define EASYXML_INVALID_FILENAME            14
#define EASYXML_INVALID_DOCTYPE             15
#define EASYXML_ERR_ALLOW_ADDRESS           16
//+------------------------------------------------------------------+
//| returns trade server return code description                     |
//+------------------------------------------------------------------+
string EasyXmlError(int return_code,int pPos=-1)
  {
   string sErrorDescription;

   switch(return_code)
     {
      case EASYXML_ERR_CONNECTION_ATTEMPT:        sErrorDescription = "Error in call of InternetAttemptConnect()"; break;
      case EASYXML_ERR_CONNECTION_OPEN:           sErrorDescription = "Error in call of InternetOpenW()"; break;
      case EASYXML_ERR_CONNECTION_URL:            sErrorDescription = "Error in call of InternetOpenUrlW()"; break;
      case EASYXML_ERR_CONNECTION_FILEOPEN:       sErrorDescription = "Error in call of FileOpen()"; break;
      case EASYXML_ERR_CONNECTION_EMPTYSTREAM:    sErrorDescription = "No return data from URL"; break;
      case EASYXML_INVALID_PROLOG:                sErrorDescription = "Invalid Prologue"; break;
      case EASYXML_INVALID_COMMENT:               sErrorDescription = "Invalid Comment"; break;
      case EASYXML_INVALID_OPENTAG_START:         sErrorDescription = "Invalid Character found. Should be the beginning of an open tag"; break;
      case EASYXML_INVALID_OPENTAG_CLOSE:         sErrorDescription = "Invalid Character found. Should be the close of an open tag"; break;
      case EASYXML_INVALID_CLOSETAG:              sErrorDescription = "Invalid Close Tag. Tags must match!"; break;
      case EASYXML_NO_CLOSETAG:                   sErrorDescription = "No Close Tag found"; break;
      case EASYXML_INVALID_CDATA:                 sErrorDescription = "Invalid CDATA"; break;
      case EASYXML_INVALID_ATTRIBUTE:             sErrorDescription = "Invalid Attribute"; break;
      case EASYXML_INVALID_FILENAME:              sErrorDescription = "Invalid Cach File Name"; break;
      case EASYXML_INVALID_DOCTYPE:               sErrorDescription = "Invalid Doctype"; break;
      case EASYXML_ERR_ALLOW_ADDRESS:             sErrorDescription = "Web address not allowed"; break;
     }

   if(pPos!=-1)
     {
      sErrorDescription+=" P:"+IntegerToString(pPos);
     }

   return("*** "+sErrorDescription+" ***");
  }
//+------------------------------------------------------------------+
