//+------------------------------------------------------------------+
//|                                               OOP_sVariant_1.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
/*
   Example of base class with children. 
   Virtual function, polymorphism.
*/
//+------------------------------------------------------------------+
//|   Base Class                                                     |
//+------------------------------------------------------------------+
class CCheckVariant
  {
public:
   virtual bool CheckVariant(int Var1,int Var2)
     {
      return(false);
     }
  };
//--- Children:
//+------------------------------------------------------------------+
//|   >                                                              |
//+------------------------------------------------------------------+

class CVariant1: public CCheckVariant
  {
   bool CheckVariant(int Var1,int Var2)
     {
      return(Var1>Var2);
     }
  };
//+------------------------------------------------------------------+
//|   <                                                              |
//+------------------------------------------------------------------+
class CVariant2: public CCheckVariant
  {
   bool CheckVariant(int Var1,int Var2)
     {
      return(Var1<Var2);
     }
  };
//+------------------------------------------------------------------+
//|   >=                                                             |
//+------------------------------------------------------------------+
class CVariant3: public CCheckVariant
  {
   bool CheckVariant(int Var1,int Var2)
     {
      return(Var1>=Var2);
     }
  };
//+------------------------------------------------------------------+
//|   <=                                                             |
//+------------------------------------------------------------------+
class CVariant4: public CCheckVariant
  {
   bool CheckVariant(int Var1,int Var2)
     {
      return(Var1<=Var2);
     }
  };
//+------------------------------------------------------------------+
//|   ==                                                             |
//+------------------------------------------------------------------+
class CVariant5: public CCheckVariant
  {
   bool CheckVariant(int Var1,int Var2)
     {
      return(Var1==Var2);
     }
  };
//--- Load class
CCheckVariant *var;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
   int Variant=5; // Number of variant
                  // Depending on variant number one of five children classes will be used
   switch(Variant)
     {
      case 1:
         var=new CVariant1;
         break;
      case 2:
         var=new CVariant2;
         break;
      case 3:
         var=new CVariant3;
         break;
      case 4:
         var=new CVariant4;
         break;
      case 5:
         var=new CVariant5;
         break;
     }
//--- Check conditions
   bool rv=var.CheckVariant(1,2);

   Alert(rv);

  }
//+------------------------------------------------------------------+
