//+------------------------------------------------------------------+
//|                                          OOP_sDeleteOrders_2.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property script_show_inputs

/*
    Example of using class to delete orders from file 
    OOP_CDeleteOrder_1.mqh (setting parameters via 
    the Init() function).
*/

// External parameters

// Select symbol. true - delete orders for all symbols, 
//                false - only for symbol of chart, where the script is running 
input bool     AllSymbol=false;
// Select types of orders to delete
input bool     BuyStop        =  false;
input bool     SellStop       =  false;
input bool     BuyLimit       =  false;
input bool     SellLimit      =  false;
input bool     BuyStopLimit   =  false;
input bool     SellStopLimit  =  false;

#include <OOP_CDeleteOrder_1.mqh> // Include file with class

COrderDelete od; // Load the class
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {

// Pass external parameters to the class
   od.Init(AllSymbol,BuyStop,SellStop,BuyLimit,SellLimit,BuyStopLimit,SellStopLimit);

// Delete orders
   bool Ret=od.Delete();

// Process result of deleting
   if(Ret)
     {
      Alert("Script ended successfully");
     }
   else
     {
      Alert("Script ended up with error, see details in Journal");
     }

  }
//+------------------------------------------------------------------+
