//+------------------------------------------------------------------+
//|                                          OOP_sDeleteOrders_1.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property script_show_inputs
/*
   Simple script to delete pending orders.
*/
// Include file to use the CTrade class from standard delivery
#include <Trade/Trade.mqh> 
// External parameters
// Select symbol. true - delete orders for all symbols, 
//                false - only for symbol of chart, where the script is running 
input bool     AllSymbol=false;
// Select types of orders to delete
input bool     BuyStop        =  false;
input bool     SellStop       =  false;
input bool     BuyLimit       =  false;
input bool     SellLimit      =  false;
input bool     BuyStopLimit   =  false;
input bool     SellStopLimit  =  false;

CTrade Trade; //   CTrade
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void OnStart()
  {
   bool Ret=true; // Variable to check function result
   for(int i=0;i<OrdersTotal();i++)
     { // Loop by all orders in terminal
      ulong Ticket=OrderGetTicket(i); // Select order and get its ticket
      if(Ticket>0)
        { // Successfully selected
         long Type=OrderGetInteger(ORDER_TYPE);
         // Check order type
         if(Type==ORDER_TYPE_BUY_STOP && !BuyStop)continue;
         if(Type==ORDER_TYPE_SELL_STOP && !SellStop)continue;
         if(Type==ORDER_TYPE_BUY_LIMIT && !BuyLimit)continue;
         if(Type==ORDER_TYPE_SELL_LIMIT && !SellLimit)continue;
         if(Type==ORDER_TYPE_BUY_STOP_LIMIT && !BuyStopLimit)continue;
         if(Type==ORDER_TYPE_SELL_STOP_LIMIT && !SellStopLimit)continue;
         if(!AllSymbol && Symbol()!=OrderGetString(ORDER_SYMBOL))continue; // Check symbol
         if(!Trade.OrderDelete(Ticket))
           { // Delete
            Ret=false; // Failed to delete
           }
        }
      else
        {
         Ret=false; // Failed to select order, unknown result, function ended up with error
         Print("Error selecting order");
        }
     }
   if(Ret)
     {
      Alert("Script ended successfully");
     }
   else
     {
      Alert("Script ended up with error, see details in Journal");
     }
  }
//+------------------------------------------------------------------+
