//+------------------------------------------------------------------+
//|                                              OOP_CLibArray_1.mqh |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
/*
   Example of using class to create a library.
   Keywords: protected and private.
   Overload.   
*/
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CLibArray
  {
private:
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   int Find(int  &aArray[],int aValue)
     { // For int. Check if an element with required value exists in array
      for(int i=0;i<ArraySize(aArray);i++)
        {
         if(aArray[i]==aValue)
           {
            return(i); // Element exists, return index of element
           }
        }
      return(-1); // No such element, return -1
     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   int Find(long  &aArray[],long aValue)
     { // For long. Check if an element with required value exists in array
      for(int i=0;i<ArraySize(aArray);i++)
        {
         if(aArray[i]==aValue)
           {
            return(i); // Element exists, return index of element
           }
        }
      return(-1); // No such element, return -1
     }
public:
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   void AddToEnd(int  &aArray[],int aValue)
     { // For int. Add to end of array
      int m_size=ArraySize(aArray);
      ArrayResize(aArray,m_size+1);
      aArray[m_size]=aValue;
     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   void AddToEnd(long  &aArray[],long aValue)
     { // For long. Add to end of array
      int m_size=ArraySize(aArray);
      ArrayResize(aArray,m_size+1);
      aArray[m_size]=aValue;
     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   void AddToEndIfNotExists(int  &aArray[],int aValue)
     { // For int. Add to end of array if there is no such value in array already
      if(Find(aArray,aValue)==-1)
        {
         AddToEnd(aArray,aValue);
        }
     }
   //+------------------------------------------------------------------+
   //|                                                                  |
   //+------------------------------------------------------------------+
   void AddToEndIfNotExists(long  &aArray[],long aValue)
     { // For long. Add to end of array if there is no such value in array already
      if(Find(aArray,aValue)==-1)
        {
         AddToEnd(aArray,aValue);
        }
     }
  };
//+------------------------------------------------------------------+
