//+------------------------------------------------------------------+
//|                                           OOP_CDeleteOrder_2.mqh |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"

/*
   Class that deletes orders with constructor and passing parameters 
   via constructor.   
*/

#include <Trade/Trade.mqh> // Include file to use the CTrade class from standard delivery
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class COrderDelete
  {
private:
   // Variables for parameters
   bool              m_AllSymbol;
   bool              m_BuyStop;
   bool              m_SellStop;
   bool              m_BuyLimit;
   bool              m_SellLimit;
   bool              m_BuyStopLimit;
   bool              m_SellStopLimit;
   CTrade            m_Trade; // Load the CTrade class
public:
   //+------------------------------------------------------------------+
   //|   Constructor                          |
   //+------------------------------------------------------------------+
   COrderDelete(bool aAllSymbol=false,bool aBuyStop=false,bool aSellStop=false,bool aBuyLimit=false,bool aSellLimit=false,bool aBuyStopLimit=false,bool aSellStopLimit=false)
     {
      Init(aAllSymbol,aBuyStop,aSellStop,aBuyLimit,aSellLimit,aBuyStopLimit,aSellStopLimit);
     }
   //+------------------------------------------------------------------+
   //|   Function to set parameters                                     |
   //+------------------------------------------------------------------+
   void Init(bool aAllSymbol,bool aBuyStop,bool aSellStop,bool aBuyLimit,bool aSellLimit,bool aBuyStopLimit,bool aSellStopLimit)
     {
      // Set parameters
      m_AllSymbol=aAllSymbol;
      m_BuyStop=aBuyStop;
      m_SellStop=aSellStop;
      m_BuyLimit=aBuyLimit;
      m_SellLimit=aSellLimit;
      m_BuyStopLimit=aBuyStopLimit;
      m_SellStopLimit=aSellStopLimit;
     }
   //+------------------------------------------------------------------+
   //|   Main function to delete orders                                 |
   //+------------------------------------------------------------------+
   bool Delete()
     {
      bool m_Ret=true; // Variable to check function result
      for(int i=0;i<OrdersTotal();i++)
        { // Loop by all orders in terminal
         ulong m_Ticket=OrderGetTicket(i); // Select order and get its ticket
         if(m_Ticket>0)
           { // Successfully selected
            long m_Type=OrderGetInteger(ORDER_TYPE);
            // Check order type
            if(m_Type==ORDER_TYPE_BUY_STOP && !m_BuyStop)continue;
            if(m_Type==ORDER_TYPE_SELL_STOP && !m_SellStop)continue;
            if(m_Type==ORDER_TYPE_BUY_LIMIT && !m_BuyLimit)continue;
            if(m_Type==ORDER_TYPE_SELL_LIMIT && !m_SellLimit)continue;
            if(m_Type==ORDER_TYPE_BUY_STOP_LIMIT && !m_BuyStopLimit)continue;
            if(m_Type==ORDER_TYPE_SELL_STOP_LIMIT && !m_SellStopLimit)continue;
            if(!m_AllSymbol && Symbol()!=OrderGetString(ORDER_SYMBOL))continue; // Check symbol
            if(!m_Trade.OrderDelete(m_Ticket))
              { // Delete
               m_Ret=false; // Failed to delete
              }
           }
         else
           {
            m_Ret=false; // Failed to select order, unknown result, function ended up with error
            Print("Error selecting order");
           }
        }
      return(m_Ret); // Return function result
     }
  };
//+------------------------------------------------------------------+
