//+------------------------------------------------------------------+
//|                                                    ShowImage.mqh |
//|                                 Copyright 2016, Vasiliy Sokolov. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, Vasiliy Sokolov."
#property link      "http://www.mql5.com"
#include "ElBmpImage.mqh"
class CElBmpImage;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnShowImage(string name, string path, int x, int y, int sub_window = 0)
{
   ResetLastError();
   bool res = ObjectCreate(ChartID(), name, OBJ_BITMAP_LABEL, sub_window, 0, 0);
   ObjectSetInteger(ChartID(), name, OBJPROP_XDISTANCE, x);
   ObjectSetInteger(ChartID(), name, OBJPROP_YDISTANCE, y);
   ObjectSetString(ChartID(), name, OBJPROP_BMPFILE, path);
}

void ShowedImage(CElBmpImage* image, int sub_window = 0)
{
   string name = image.Name();
   if(ObjectFind(ChartID(), name) < 0)
      ObjectCreate(ChartID(), name, OBJ_BITMAP_LABEL, sub_window, 0, 0);   
   ObjectSetString(ChartID(), name, OBJPROP_BMPFILE, image.Path());
   ObjectSetInteger(ChartID(), name, OBJPROP_XDISTANCE, image.XCoord());
   ObjectSetInteger(ChartID(), name, OBJPROP_YDISTANCE, image.YCoord());
   ChartRedraw();
}

