//+------------------------------------------------------------------+
//|                                                     Grey CCI.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Grey CCI"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ushort iPeriod=14;

int period,indx1,indx2;
double buffer[],grey[],rez[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);

   period=MathMax(3,iPeriod);
   ArrayResize(grey,period);

   int size=period*(period-1)/2;
   ArrayResize(rez,size);

   indx1=size/2;
   indx2=MathMod(size,2)==0?indx1+1:indx1;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int32_t rates_total,
                const int32_t prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int32_t &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-period-1;

      for(int i=bars;i>=0;i--)
        {
         for(int j=0;j<period;j++)
            grey[j]=open[i+j];

         double ma=GreyEstimator();

         for(int j=0;j<period;j++)
            grey[j]=MathAbs(open[i+j]-ma);

         double stdev=0.015*GreyEstimator();

         buffer[i]=(open[i]-ma)/stdev;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double GreyEstimator()
  {
//---
   for(int j=period-2;j>=0;j--)
      grey[j]=grey[j]+grey[j+1];

   int cnt=0;
   for(int j=period-2;j>=0;j--)
      for(int k=j+1;k<period;k++)
        {
         rez[cnt]=(grey[j]-grey[k])/(k-j);
         cnt++;
        }

   ArraySort(rez);
   return((rez[indx1]+rez[indx2])/2);
//---
  }
//+------------------------------------------------------------------+
