//+------------------------------------------------------------------+
//|                                                EA Grey MA LQ.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#resource "\\Indicators\\Grey MA.ex5"

#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
CPositionInfo pos;
CTrade trade;

enum trend {Linear,Quadratic,Power};
input trend Trend1=Linear,
            Trend2=Quadratic;
input ushort iPeriod1=24,
             iPeriod2=780,
             Filter=50;

int handle1,handle2;
double lot;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   handle1=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\Grey MA.ex5",Trend1,iPeriod1);
   handle2=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\Grey MA.ex5",Trend2,iPeriod2);
   if(handle1==INVALID_HANDLE || handle2==INVALID_HANDLE)
     {
      Print("Error code = ",GetLastError());
      return(INIT_FAILED);
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();

      if(signal==0)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_SELL)
               trade.PositionClose(pos.Ticket(),10);

         trade.Buy(lot);
        }

      if(signal==1)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_BUY)
               trade.PositionClose(pos.Ticket(),10);

         trade.Sell(lot);
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalcSignal()
  {
//---
   char signal=-1;
   double ind1[2],ind2[2];
   int c1=CopyBuffer(handle1,0,0,2,ind1),
       c2=CopyBuffer(handle2,0,0,2,ind2);

   if(c1>1 && c2>1)
     {
      if(ind2[0]>ind2[1] && ind1[0]<ind1[1] && ind2[0]-ind1[0]>=Filter*_Point)
         signal=0;
      if(ind2[0]<ind2[1] && ind1[0]>ind1[1] && ind1[0]-ind2[0]>=Filter*_Point)
         signal=1;
     }

   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
