//+------------------------------------------------------------------+
//|                                                  EA Grey CCI.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#resource "\\Indicators\\Grey CCI.ex5"

#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
CPositionInfo pos;
CTrade trade;

input ushort iPeriod=36,
             Filter=130;

int handle;
double lot;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   handle=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\Grey CCI.ex5",iPeriod);
   if(handle==INVALID_HANDLE)
     {
      Print("Error code = ",GetLastError());
      return(INIT_FAILED);
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();

      if(signal==0)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_SELL)
               trade.PositionClose(pos.Ticket(),10);

         trade.Buy(lot);
        }

      if(signal==1)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_BUY)
               trade.PositionClose(pos.Ticket(),10);

         trade.Sell(lot);
        }

      if(signal==2)
         trade.Buy(lot);

      if(signal==3)
         trade.Sell(lot);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalcSignal()
  {
//---
   char signal=-1;
   double ind[2];
   int c=CopyBuffer(handle,0,0,2,ind);

   if(c>1)
     {
      if(ind[0]<ind[1] && -ind[0]>Filter)
         signal=0;
      if(ind[0]>ind[1] && ind[0]>Filter)
         signal=1;
      if(ind[0]>0 && ind[1]<0)
         signal=2;
      if(ind[0]<0 && ind[1]>0)
         signal=3;
     }

   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
