//+------------------------------------------------------------------+
//|                                                    Wandering.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_minimum 0
#property indicator_maximum 2.5

#property indicator_level1 0.5
#property indicator_level2 1
#property indicator_level3 2

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Power"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ushort iPeriod=24;
int period;
double buffer[],price[],denom=0,t1=0,t2=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);

   period=MathMax(3,iPeriod);
   ArrayResize(price,period);

   for(int i=0;i<period;i++)
     {
      double tlog=MathLog(period-i);
      t1=t1+tlog;
      t2=t2+tlog*tlog;
     }

   denom=(period-1)*t2-t1*t1;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0?rates_total-prev_calculated-1:rates_total-2*period;

      for(int i=bars;i>=0;i--)
        {
         int pos=i+period-1;
         for(int j=pos;j<rates_total;j++)
           {
            double var=MathAbs(open[pos]-open[j]);
            if(var>0)
              {
               price[period-1]=var;
               break;
              }
           }

         for(int j=period-2;j>=0;j--)
           {
            pos=i+j;
            price[j]=price[j+1]+MathAbs(open[pos]-open[pos+1]);
           }

         double r=0,rt=0,d=price[period-1];
         for(int j=0;j<period;j++)
           {
            double var=MathLog(price[j]/d);
            r=r+var;
            rt=rt+var*MathLog(period-j);
           }

         buffer[i]=((period-1)*rt-r*t1)/denom;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
