//+------------------------------------------------------------------+
//|                                             Price Increments.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots   2

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Up"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_type2  DRAW_LINE
#property indicator_label2 "Down"
#property indicator_color2 clrRed
#property indicator_width2 1
#property indicator_style2 STYLE_SOLID

input uchar Percent=33;

int array[][2],size=1,counter=0;
double bufferup[],bufferdn[],percdn,percup;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,bufferup,INDICATOR_DATA);
   PlotIndexSetInteger(0,PLOT_SHIFT,1);
   ArraySetAsSeries(bufferup,true);

   SetIndexBuffer(1,bufferdn,INDICATOR_DATA);
   PlotIndexSetInteger(1,PLOT_SHIFT,1);
   ArraySetAsSeries(bufferdn,true);

   ArrayResize(array,1,1000);
   ArrayInitialize(array,0);

   percdn=0.5*(100-MathMin(99,MathMax(1,Percent)));
   percup=100-percdn;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-2;

      for(int i=bars;i>=0;i--)
        {
         int value=(int)MathRound((open[i]-open[i+1])/_Point),
             indx=ArrayBsearch(array,value);

         if(array[indx][0]==value)
            array[indx][1]=array[indx][1]+100;
         else
           {
            ArrayResize(array,size+1);
            array[size][0]=value;
            array[size][1]=100;
            size++;
            ArraySort(array);
           }
         counter++;

         int sum=0,up=0,dn=0;
         for(int j=0;j<size;j++)
           {
            sum=sum+array[j][1];
            if(percup*counter>sum)
              {
               up=array[j][0];
               if(percdn*counter>sum)
                  dn=array[j][0];
              }
            else
               break;
           }

         bufferup[i]=open[i]+up*_Point;
         bufferdn[i]=open[i]+dn*_Point;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
