//+------------------------------------------------------------------+
//|                                                        Error.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property script_show_inputs

#include <Graphics\Graphic.mqh>

input uchar Duration=1;
input bool ScreenShot=true;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   int array[][2],size=1;
   ArrayResize(array,size,1000);
   ArrayInitialize(array,0);

   for(int i=iBars(_Symbol,PERIOD_CURRENT)-1;i>=Duration;i--)
     {
      int value=(int)MathRound((iOpen(_Symbol,PERIOD_CURRENT,i-Duration)-iOpen(_Symbol,PERIOD_CURRENT,i))/_Point),
          indx=ArrayBsearch(array,value);

      if(array[indx][0]==value)
         array[indx][1]++;
      else
        {
         ArrayResize(array,size+1);
         array[size][0]=value;
         array[size][1]=1;
         size++;
         ArraySort(array);
        }
     }

   double x[],y[];
   ArrayResize(x,size);
   ArrayResize(y,size);
   for(int i=0;i<size;i++)
     {
      x[i]=array[i][0];
      y[i]=array[i][1];
     }
//---
   ChartSetInteger(0,CHART_SHOW,false);
   int w=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       h=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);

   CGraphic graphic;
   graphic.Create(0,"graph",0,0,0,w,h);

   CCurve *hist=graphic.CurveAdd(x,y,CURVE_HISTOGRAM);
   hist.Name(MQLInfoString(MQL_PROGRAM_NAME));

   graphic.CurvePlotAll();
   graphic.Update();
   if(ScreenShot==true)
      ChartScreenShot(0,MQLInfoString(MQL_PROGRAM_NAME)+".png",w,h);
   Sleep(5000);

   graphic.Destroy();
   ChartSetInteger(0,CHART_SHOW,true);
//---
  }
//+------------------------------------------------------------------+
