//+------------------------------------------------------------------+
//|                                               EA Picky Bride.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#include <Trade\Trade.mqh>
CTrade trade;

input uint Seed=913723722;
input ushort Duration=10;//Trade duration

ushort duration=1;
int minsl,up[],sizeup=1,dn[],sizedn=1;
double lot;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   MathSrand(Seed);
   duration=MathMax(duration,Duration);
   minsl=(int)SymbolInfoInteger(_Symbol,SYMBOL_TRADE_STOPS_LEVEL);
   ArrayResize(up,sizeup);
   up[0]=0;
   ArrayResize(dn,sizedn);
   dn[0]=0;
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   for(int i=iBars(_Symbol,PERIOD_CURRENT)-1;i>duration;i--)
      CalcLVL(i);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      CalcLVL(duration);

      if(PositionsTotal()>0)
         return;

      int signal=MathRand()%2;

      if(signal==0)
        {
         double price=SymbolInfoDouble(_Symbol,SYMBOL_ASK),
                sl=NormalizeDouble(price-CalcSL(dn,sizedn)*_Point,_Digits),
                tp=NormalizeDouble(price+CalcTP(up,sizeup)*_Point,_Digits);
         trade.Buy(lot,_Symbol,price,sl,tp,NULL);
        }
      else
        {
         double price=SymbolInfoDouble(_Symbol,SYMBOL_BID),
                sl=NormalizeDouble(price+CalcSL(up,sizeup)*_Point,_Digits),
                tp=NormalizeDouble(price-CalcTP(dn,sizedn)*_Point,_Digits);
         trade.Sell(lot,_Symbol,price,sl,tp,NULL);
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CalcSL(int &arr[],int size)
  {
//---
   int a[],sl=0;
   ulong max=0;
   ArrayResize(a,size+1);
   a[size]=1;
   for(int i=size-1;i>-1;i--)
      a[i]=a[i+1]+arr[i]+1;
   for(int i=1;i<size;i++)
     {
      ulong res=(size-i)*(a[0]-a[i]);
      if(max<res)
         max=res;
      else
        {
         sl=i-1;
         break;
        }
     }
   return(MathMax(sl,minsl));
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CalcTP(int &arr[],int size)
  {
//---
   int a[],tp=0;
   ulong max=0;
   ArrayResize(a,size+1);
   a[size]=1;
   for(int i=size-1;i>-1;i--)
      a[i]=a[i+1]+arr[i]+1;
   for(int i=1;i<size;i++)
     {
      ulong res=i*a[i];
      if(max<res)
         max=res;
      else
        {
         tp=i-1;
         break;
        }
     }
   return(MathMax(tp,minsl));
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalcLVL(int bar)
  {
//---
   int pos=bar;
   double open=iOpen(_Symbol,PERIOD_CURRENT,pos),
          high=iHigh(_Symbol,PERIOD_CURRENT,pos),
          low=iLow(_Symbol,PERIOD_CURRENT,pos);

   for(int i=1;i<duration;i++)
     {
      pos--;
      high=MathMax(high,iHigh(_Symbol,PERIOD_CURRENT,pos));
      low=MathMin(low,iLow(_Symbol,PERIOD_CURRENT,pos));
     }

   CalcArray(up,sizeup,(int)MathRound((high-open)/_Point));
   CalcArray(dn,sizedn,(int)MathRound((open-low)/_Point));
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalcArray(int &arr[],int &size,int value)
  {
//---
   if(value<size)
      arr[value]++;
   else
     {
      int a[],s=value+1;
      ArrayResize(a,s);
      for(int i=0;i<size;i++)
         a[i]=arr[i];
      for(int i=size;i<s;i++)
         a[i]=0;
      a[value]=1;
      size=s;
      ArrayResize(arr,size);
      for(int i=0;i<size;i++)
         arr[i]=a[i];
      ArrayFree(a);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
