//+------------------------------------------------------------------+
//|                                                      Kendall.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_level1 33
#property indicator_level2 67

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Kendall"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ushort iPeriod=24;//Indicator period
struct DEV {int array[][2];int size;};
DEV dev[];
ushort period=3;
double buffer[],max=0,min=DBL_MAX;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);

   IndicatorSetInteger(INDICATOR_DIGITS,1);

   period=MathMax(period,iPeriod);
   ArrayResize(dev,period-1);
   for(int i=0;i<period-1;i++)
     {
      ArrayResize(dev[i].array,1,5000);
      ArrayInitialize(dev[i].array,0);
      dev[i].size=1;
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-period-1;

      for(int i=bars;i>=0;i--)
        {
         double sum=0;
         for(int j=period-2;j>=0;j--)
           {
            int p=i+j;
            for(int h=j+1,indx=0;h<period;h++,indx++)
              {
               int diff=(int)MathRound((open[p]-open[i+h])/_Point),s=ArrayBsearch(dev[indx].array,diff);
               if(dev[indx].array[s][0]==diff)
                  dev[indx].array[s][1]++;
               else
                 {
                  ArrayResize(dev[indx].array,dev[indx].size+1);
                  dev[indx].array[dev[indx].size][0]=diff;
                  dev[indx].array[dev[indx].size][1]=1;
                  dev[indx].size++;
                  ArraySort(dev[indx].array);
                  s=ArrayBsearch(dev[indx].array,diff);
                 }
               sum=sum+CalcCDF(dev[indx].array,s);
              }
           }

         max=MathMax(max,sum);
         min=MathMin(min,sum);

         buffer[i]=max>min? 100*(sum-min)/(max-min):EMPTY_VALUE;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CalcCDF(int &a[][2],int indx)
  {
//---
   int res=0;
   for(int i=indx;i>=0;i--)
      res=res+a[i][1];
   return(res);
//---
  }
//+------------------------------------------------------------------+
