//+------------------------------------------------------------------+
//|                                                    EA Abbe 3.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#resource "\\Indicators\\Abbe 3.ex5"

#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
CPositionInfo pos;
CTrade trade;

input ushort iPeriod=40;//Indicator period
input uchar LvlMax=70,
            LvlMin=30,
            LvlTrend=25;

int handle;
double lot;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   handle=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\Abbe 3.ex5",iPeriod);
   if(handle==INVALID_HANDLE)
     {
      Print("Error code = ",GetLastError());
      return(INIT_FAILED);
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();

      if(signal==0)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_SELL)
               trade.PositionClose(pos.Ticket(),10);

         trade.Buy(lot);
        }

      if(signal==1)
        {
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true && pos.PositionType()==POSITION_TYPE_BUY)
               trade.PositionClose(pos.Ticket(),10);

         trade.Sell(lot);
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalcSignal()
  {
//---
   char signal=-1;
   double ind1[1],ind2[2];
   int c1=CopyBuffer(handle,0,0,1,ind1),
       c2=CopyBuffer(handle,1,0,2,ind2);

   if(c1>0 && c2>1)
     {
      if(ind1[0]>LvlMax || ind1[0]<LvlMin)
        {
         if(ind2[1]<ind2[0] && ind2[0]<50-LvlTrend)
            signal=0;
         if(ind2[1]>ind2[0] && ind2[0]>50+LvlTrend)
            signal=1;
        }
     }

   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
