//+------------------------------------------------------------------+
//|                                                    EA Abbe 1.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#resource "\\Indicators\\Abbe 1.ex5"

#include <Trade\PositionInfo.mqh>
#include <Trade\Trade.mqh>
CPositionInfo pos;
CTrade trade;

input ushort iPeriod=525;//Indicator period
input uchar LvlStDev=33,
            LvlDevAl=33,
            LvlTrend=25;

int handle;
double lot;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   handle=iCustom(_Symbol,PERIOD_CURRENT,"::Indicators\\Abbe 1.ex5",iPeriod);
   if(handle==INVALID_HANDLE)
     {
      Print("Error code = ",GetLastError());
      return(INIT_FAILED);
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      int signal=CalcSignal();

      if(signal==0)
         trade.Buy(lot);

      if(signal==1)
         trade.Sell(lot);

      if(signal==2)
         for(int i=PositionsTotal()-1;i>=0;i--)
            if(pos.SelectByIndex(i)==true)
               trade.PositionClose(pos.Ticket(),10);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalcSignal()
  {
//---
   char signal=-1;
   double ind1[1],ind2[1],ind3[1];
   int c1=CopyBuffer(handle,0,0,1,ind1),
       c2=CopyBuffer(handle,1,0,1,ind2),
       c3=CopyBuffer(handle,2,0,1,ind3);

   if(c1>0 && c2>0 && c3>0)
     {
      if(ind1[0]>LvlStDev && ind2[0]>LvlDevAl)
        {
         if(ind3[0]<50-LvlTrend)
            signal=0;
         if(ind3[0]>50+LvlTrend)
            signal=1;
        }
      if(ind3[0]>50-LvlTrend && ind3[0]<50+LvlTrend)
         signal=2;
     }

   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long lastbar;
   long curbar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(lastbar<curbar)
     {
      lastbar=curbar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
