//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T> class C_NODE
{
    private :
//+----------------+
        T           m_info;
        C_NODE <T>  *m_next,
                    *m_prev;
//+----------------+
    public  :
//+----------------+
        C_NODE(const T arg1, C_NODE <T> *arg2, C_NODE <T> *arg3) : m_info(arg1), m_prev(arg2), m_next(arg3) {}
//+----------------+
        ~C_NODE()
        {
            if (m_prev != NULL) (*m_prev).m_next = m_next;
            if (m_next != NULL) (*m_next).m_prev = m_prev;
        }
//+----------------+
        const T info(void) { return m_info; }
//+----------------+
        C_NODE <T> *prev(void) { return m_prev; }
//+----------------+
        C_NODE <T> *next(void) { return m_next; }
//+----------------+
        void setPrev(C_NODE <T> *arg) { m_prev = arg; }
//+----------------+
        void setNext(C_NODE <T> *arg) { m_next = arg; }
//+----------------+
        void operator=(const T arg) { m_info = arg; }
//+----------------+
        T operator>>=(T &arg) const { return (arg = m_info); }
//+----------------+
        void operator<<=(const T arg)
        {
            C_NODE <T>  *loc = new C_NODE<T>(arg, m_prev, GetPointer(this));            
            if (m_prev != NULL) (*m_prev).m_next = loc;
            m_prev = loc;
        }
//+----------------+
};
//+------------------------------------------------------------------+
template <typename T> class C_Demo
{
    private :
//+----------------+
        C_NODE <T>  *m_Base,
                    *m_Top;
//+----------------+
        C_NODE<T> *AdjustBase(C_NODE <T> *arg) { return m_Base = (m_Base == NULL ? arg : ((*m_Base).prev() == NULL ? m_Base : (*m_Base).prev())); }
//+----------------+
    public  :
//+----------------+
        C_Demo(): m_Base(NULL), m_Top(NULL) {}
//+----------------+
        ~C_Demo()
        {
            for(C_NODE <T> *ptr = (*m_Top).prev(); m_Top != NULL; m_Top = ptr, ptr = (ptr != NULL ? (*m_Top).prev() : NULL))
                delete m_Top;
        }
//+----------------+
        void operator<<(const T arg)
        {
            C_NODE <T> *tmp = m_Top;

            m_Top = new C_NODE <T> (arg, m_Top, NULL);
            if (tmp != NULL) tmp.setNext(m_Top);
            AdjustBase(m_Top);
        }
//+----------------+
        bool operator>>(T &arg)
        {
            C_NODE <T> *tmp;

            if ((tmp = AdjustBase(m_Base)) == NULL) return false;
            arg = (*m_Base).info();
            if ((m_Base = (*m_Base).next()) != NULL) (*m_Base).setPrev(NULL);
            delete tmp;
            return true;
        }
//+----------------+
        C_NODE <T> *operator[](const uint arg)
        {
            C_NODE <T> *loc = AdjustBase(m_Base);
            for (uint c = 0; (loc != NULL) && (c < arg); loc = (*loc).next(), c++);
            return loc;
        }
//+----------------+
        void Exclude(const uint arg)
        {
            C_NODE <T>  *loc = AdjustBase(m_Base),
                        *ptr = NULL,
                        *tmp;
            for (uint c = 0; (loc != NULL) && (c < arg); ptr = loc, loc = (*loc).next(), c++);
            tmp = (*loc).next();
            delete loc;
            if (ptr != NULL) m_Top = ((*ptr).next() == NULL ? ptr : m_Top);
                else m_Base = tmp;
        }
//+----------------+
        void Debug(string fn, uint line)
        {
            Print("===== DEBUG [", fn, " :: ", line, "]=====");
            for (C_NODE<T>*loc = AdjustBase(m_Base); (loc != NULL); loc = (*loc).next())
                PrintFormat("0x%08X ->> 0x%08X <<- 0x%08X = [%d]", (*loc).prev(), loc, (*loc).next(), (*loc).info());
            Print("=================");
        }
//+----------------+
};
//+------------------------------------------------------------------+