//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T> class C_Demo
{
    private:
//+----------------+
        T           m_info;
        C_Demo <T>  *m_prev,
                    *m_next;
//+----------------+
#define def_Adjust(x) (m_prev = (m_prev == NULL ? x : ((*m_prev).m_prev != NULL ? (*m_prev).m_prev : m_prev)))
//+----------------+
        void Debug_Private(string fn, uint line)
        {
            Print("===== DEBUG [", fn, " :: ", line, "]=====");
            for (C_Demo <T> *loc = m_prev; (loc != NULL); loc = (*loc).m_next)
                PrintFormat("0x%06X ->> 0x%06X <<- 0x%06X = [%d]", (*loc).m_prev, loc, (*loc).m_next, (*loc).m_info);
            Print("=================");
        }
//+----------------+
    public:
//+----------------+
        C_Demo() : m_next(NULL), m_prev(NULL) {}
//+----------------+
        ~C_Demo()
        {
            for (T loc; this >> loc;);
        }
//+----------------+
        void operator<<(const T arg)
        {
            C_Demo <T>  *loc = new C_Demo <T>;
                        
            (*loc).m_info = arg;
            (*loc).m_prev = m_next;
            if (m_next != NULL) (*m_next).m_next = loc;
            m_next = loc;
            m_prev = def_Adjust(loc);
        }
//+----------------+
        bool operator>>(T &arg)
        {
            C_Demo <T> *loc = def_Adjust(m_prev);
            if (loc == NULL) return false;
            arg = (*loc).m_info;
            if ((m_prev = (*loc).m_next) != NULL) (*m_prev).m_prev = NULL;
            delete loc;

            return true;
        }
//+----------------+
        C_Demo <T> *operator[](const uint arg)
        {
            C_Demo <T> *loc = def_Adjust(m_prev);
            for (uint c = 0; (loc != NULL) && (c < arg); loc = (*loc).m_next, c++);
            return loc;
        }
//+----------------+
        void operator=(const T arg)
        {
            m_info = arg;
        }
//+----------------+
        void operator<<=(const T arg)
        {
            C_Demo <T>  *loc = new C_Demo <T>;
            
            (*loc).m_info = arg;
            (*loc).m_next = GetPointer(this);
            (*loc).m_prev = m_prev;
            if (m_prev != NULL) (*m_prev).m_next = loc;
            m_prev = loc;
        }
//+----------------+
        T operator>>=(T &arg)
        {
            return (arg = m_info);
        }
//+----------------+
        void Debug(string fn, uint line)
        {
            m_prev = def_Adjust(m_prev);
            Debug_Private(fn, line);
        }
//+----------------+
#undef def_Adjust
//+----------------+
};
//+------------------------------------------------------------------+