//+------------------------------------------------------------------+
//|                                                        qsort.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
//+------------------------------------------------------------------+
//| quick sort a vector                                              |
//+------------------------------------------------------------------+
void qsortd(long first, long last, vector &data)
  {
   long lower, upper ;
   double ftemp, split ;

   split = data[(first+last)/2] ;
   lower = long(first) ;
   upper = long(last) ;

   do
     {
      while(split > data[lower])
         ++lower ;
      while(split < data[upper])
         --upper ;
      if(lower == upper)
        {
         ++lower ;
         --upper ;
        }
      else
         if(lower < upper)
           {
            ftemp = data[lower] ;
            data[lower++] = data[upper] ;
            data[upper--] = ftemp ;
           }
     }
   while(lower <= upper) ;

   if(first < upper)
      qsortd(first, upper, data) ;
   if(lower < last)
      qsortd(lower, last, data) ;
  }
//+------------------------------------------------------------------+
//|sort based on slave of indicces                                   |
//+------------------------------------------------------------------+
void qsortdsi(long first, long last, vector &data, long &slave[])
  {
   long lower, upper, itemp ;
   double ftemp, split ;

   split = data[(first+last)/2] ;
   lower = long(first) ;
   upper = long(last) ;

   do
     {
      while(split > data[lower])
         ++lower ;
      while(split < data[upper])
         --upper ;
      if(lower == upper)
        {
         ++lower ;
         --upper ;
        }
      else
         if(lower < upper)
           {
            itemp = slave[lower] ;
            slave[lower] = slave[upper] ;
            slave[upper] = itemp ;
            ftemp = data[lower] ;
            data[lower++] = data[upper] ;
            data[upper--] = ftemp ;
           }
     }
   while(lower <= upper) ;

   if(first < upper)
      qsortdsi(first, upper, data, slave) ;
   if(lower < last)
      qsortdsi(lower, last, data, slave) ;
  }