//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T> class C_Demo
{
    private:
//+----------------+
        uint        m_counter;
        T           m_info;
        C_Demo <T>  *m_prev,
                    *m_next;
//+----------------+
        void Store(T arg1, const uint arg2 = UINT_MAX)
        {
            C_Demo <T>  *loc = new C_Demo <T>,
                        *ptr1 = m_next,
                        *ptr2 = NULL;
            for (uint c = 0; (ptr1 != NULL) && (c < arg2); ptr2 = ptr1, ptr1 = (*ptr1).m_next, c++);

            (*loc).m_info = arg1;
            (*loc).m_next = (ptr2 != NULL ? (*ptr2).m_next : ptr1);
            (*loc).m_prev = (ptr1 != NULL ? (*ptr1).m_prev : ptr2);
            if (ptr1 != NULL) (*ptr1).m_prev = loc; else m_prev = loc;
            if (ptr2 != NULL) (*ptr2).m_next = loc; else m_next = loc;
            m_counter++;
        }
//+----------------+
        bool Restore(T &arg1, const uint arg2 = UINT_MAX)
        {
            if ((m_prev == NULL) && (m_next == NULL)) return false;
            C_Demo <T>  *loc = (arg2 < m_counter ? m_next : m_prev),
                        *ptr = NULL;

            for (uint c = 0; (loc != NULL) && (c < arg2) && (arg2 < m_counter); ptr = loc, loc = (*loc).m_next, c++);
            if (loc == NULL) return false;
            if (arg2 == 0)
            {
                m_next = (*loc).m_next;
                if (m_next != NULL) (*m_next).m_prev = NULL;
            }else if (arg2 >= (m_counter - 1))
            {
                m_prev = (*loc).m_prev;
                if (m_prev != NULL) (*m_prev).m_next = NULL;
            }else
            {
                (*ptr).m_next = (*loc).m_next;
                (*loc).m_next.m_prev = ptr;
            }
            arg1 = (*loc).m_info;
            delete loc;
            m_counter--;
            m_prev = (m_counter ? m_prev : NULL);

            return true;
        }
//+----------------+
    public:
//+----------------+
        C_Demo() : m_counter(0), m_next(NULL), m_prev(NULL) {}
//+----------------+
        void operator<<(const T arg)
        {
            Store(arg);
        }
//+----------------+
        bool operator>>(T &arg)
        {
            return Restore(arg); // Stack mode
            // return Restore(arg, 0); // FIFO mode
        }
//+----------------+
        C_Demo <T> *operator[](const uint arg)
        {
            C_Demo <T> *loc = m_next;
            for (uint c = 0; (loc != NULL) && (c < arg); loc = (*loc).m_next, c++);

            return loc;
        }
//+----------------+
        void operator=(const T arg)
        {
            m_info = arg;
        }
//+----------------+
        void Debug(void)
        {
            Print("===== DEBUG =====");
            for (C_Demo <T> *loc = m_next; loc != NULL; loc = (*loc).m_next)
                PrintFormat("0x%06X ->> 0x%06X <<- 0x%06X = [%d]", (*loc).m_next, loc, (*loc).m_prev, (*loc).m_info);
            Print("=================");
        }
//+----------------+
};
//+------------------------------------------------------------------+