//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2020, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
#property copyright ""
#property link      ""
#property version   "1.01"
#property strict

// Adjustable Inputs
input string pythonUrl = "http://127.0.0.1:5000/analyze"; // Python server endpoint
input int timeout = 50000;                                // Timeout in milliseconds (adjustable)
input int signalInterval = 60;                            // Time interval (in seconds) between signal updates (adjustable)

// Global variables to store last update time and signal
datetime lastSignalTime = 0;
string lastSignal = "";

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   Print("Expert initialized. Ready to send data to Python.");
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   Print("Expert deinitialized.");
  }

//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
// Check if enough time has passed since the last signal update
   if(TimeCurrent() - lastSignalTime < signalInterval)
     {
      return;  // Skip if it's too soon to update
     }

// Collect data and prepare CSV for Python
   string csvData = "date,prev_high,prev_low,prev_open,prev_close,prev_volume\n";

// Get the previous trend data for the last `trendDays`
   for(int i = 1; i <= 10; i++)   // You can adjust the trendDays here
     {
      datetime prevDate = iTime(Symbol(), PERIOD_D1, i);
      double prevHigh = iHigh(Symbol(), PERIOD_D1, i);
      double prevLow = iLow(Symbol(), PERIOD_D1, i);
      double prevOpen = iOpen(Symbol(), PERIOD_D1, i);
      double prevClose = iClose(Symbol(), PERIOD_D1, i);
      long prevVolume = iVolume(Symbol(), PERIOD_D1, i);

      csvData += StringFormat("%s,%.5f,%.5f,%.5f,%.5f,%ld\n",
                              TimeToString(prevDate, TIME_DATE | TIME_MINUTES),
                              prevHigh, prevLow, prevOpen, prevClose, prevVolume);
     }

// Save data to CSV file
   string fileName = StringFormat("%s_analytics.csv", Symbol());
   int fileHandle = FileOpen(fileName, FILE_WRITE | FILE_CSV | FILE_ANSI);

   if(fileHandle != INVALID_HANDLE)
     {
      FileWriteString(fileHandle, csvData);
      FileClose(fileHandle);
      Print("CSV file created: ", fileName);

      char data[];
      StringToCharArray(csvData, data);

      string headers = "Content-Type: application/json\r\n";
      char result[];
      string resultHeaders;
      int responseCode = WebRequest(
                            "POST",                  // HTTP method
                            pythonUrl,               // URL
                            headers,                 // Custom headers
                            timeout,                 // Timeout in milliseconds
                            data,                    // Data to send
                            result,                  // Response content
                            resultHeaders            // Response headers
                         );

      if(responseCode == 200)
        {
         string response = CharArrayToString(result);
         Print("Received response: ", response);

         // Parse the response (assume JSON format)
         string signal = "";
         string avgPrice = "";
         string avgVolume = "";
         string explanation = "";

         // Extract signal, avgPrice, avgVolume, and explanation from the response
         int signalStart = StringFind(response, "\"signal\":");
         int signalEnd = StringFind(response, "\"average_price\":");
         int explanationStart = StringFind(response, "\"signal_explanation\":");
         int avgPriceStart = StringFind(response, "\"average_price\":");
         int avgVolumeStart = StringFind(response, "\"average_volume\":");

         if(signalStart != -1 && signalEnd != -1)
           {
            signal = StringSubstr(response, signalStart + 10, signalEnd - signalStart - 12);
           }

         if(explanationStart != -1)
           {
            explanation = StringSubstr(response, explanationStart + 23, StringFind(response, "\"", explanationStart + 23) - (explanationStart + 23));
           }

         if(avgPriceStart != -1)
           {
            avgPrice = StringSubstr(response, avgPriceStart + 16, StringFind(response, "\"", avgPriceStart + 16) - (avgPriceStart + 16));
           }

         if(avgVolumeStart != -1)
           {
            avgVolume = StringSubstr(response, avgVolumeStart + 18, StringFind(response, "\"", avgVolumeStart + 18) - (avgVolumeStart + 18));
           }

         // Only update the chart if the signal has changed
         if(signal != lastSignal)
           {
            lastSignal = signal;
            lastSignalTime = TimeCurrent(); // Update last signal time
            // Display the received signal and metrics
            string receivedSummary = "Signal: " + signal + "\n" +
                                     "Avg Price: " + avgPrice + "\n" +
                                     "Avg Volume: " + avgVolume + "\n" +
                                     "Explanation: " + explanation;

            Print("Received metrics and signal: ", receivedSummary);
            Comment(receivedSummary);  // Display it on the chart
           }
        }
      else
        {
         Print("Error: HTTP request failed with code ", responseCode);
        }
     }
   else
     {
      Print("Error: Failed to create CSV file.");
     }
  }

//+------------------------------------------------------------------+
//| Convert char array to string                                     |
//+------------------------------------------------------------------+
string CharArrayToString(char &arr[])
  {
   string result = "";
   for(int i = 0; i < ArraySize(arr); i++)
     {
      result += StringFormat("%c", arr[i]);
     }
   return (result);
  }
//+------------------------------------------------------------------+
