//XAU-1h
#include <Trade/Trade.mqh>
#resource "\\Files\\regression2024.onnx" as uchar lstm_onnx[]
CTrade trade;

float data[1][5][3];
float out[1][1];

input int MaPeriodsFast = 15;
input int MaPeriodsSlow = 25;
input double lott = 0.01;
input int threshold = 30;
ulong buypos = 0, sellpos = 0;
input int Magic = 0;
int barsTotal = 0;
long lstmHandle = INVALID_HANDLE;
const long input_shape[] = {1,5,3};
const long output_shape[]={1,1};

int handleMaFast;
int handleMaSlow;
int handleAdx;     // Average Directional Movement Index - 3
int handleRsi;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {//Initialize model
   trade.SetExpertMagicNumber(Magic);
   handleMaFast =iMA(_Symbol,PERIOD_CURRENT,MaPeriodsFast,0,MODE_SMA,PRICE_CLOSE);
   handleMaSlow =iMA(_Symbol,PERIOD_CURRENT,MaPeriodsSlow,0,MODE_SMA,PRICE_CLOSE);   
   handleAdx=iADX(_Symbol,PERIOD_CURRENT,14);//Average Directional Movement Index - 3
   handleRsi = iRSI(_Symbol,PERIOD_CURRENT,14,PRICE_CLOSE);
    // Load the ONNX model
   lstmHandle = OnnxCreateFromBuffer(lstm_onnx, ONNX_DEFAULT);
   //--- specify the shape of the input data
   if(!OnnxSetInputShape(lstmHandle,0,input_shape))
     {
      Print("OnnxSetInputShape failed, error ",GetLastError());
      OnnxRelease(lstmHandle);
      return(-1);
     }
//--- specify the shape of the output data
   if(!OnnxSetOutputShape(lstmHandle,0,output_shape))
     {
      Print("OnnxSetOutputShape failed, error ",GetLastError());
      OnnxRelease(lstmHandle);
      return(-1);
     }
   if (lstmHandle == INVALID_HANDLE)
   {
      Print("Error creating model OnnxCreateFromBuffer ", GetLastError());
      return(INIT_FAILED);
   }
   return(INIT_SUCCEEDED);
  }
  
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {

  }
  
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
  int bars = iBars(_Symbol,PERIOD_CURRENT);
  if (barsTotal!= bars){
     barsTotal = bars;
     double maFast[];
     double maSlow[];
     double adx[];
     CopyBuffer(handleMaFast,BASE_LINE,1,2,maFast);
     CopyBuffer(handleMaSlow,BASE_LINE,1,2,maSlow);
     CopyBuffer(handleAdx,0,1,1,adx);
     double bid = SymbolInfoDouble(_Symbol, SYMBOL_BID);
     double ask = SymbolInfoDouble(_Symbol, SYMBOL_ASK);
     double lastClose = iClose(_Symbol, PERIOD_CURRENT, 1);
     //The order below matters
     if(buypos>0&& lastClose<maSlow[1]) trade.PositionClose(buypos);
     if(sellpos>0 &&lastClose>maSlow[1])trade.PositionClose(sellpos);   
     if(maFast[1]<maSlow[1]&&maFast[0]>maSlow[0]&&sellpos == buypos){
        getData();
        OnnxRun(lstmHandle, ONNX_NO_CONVERSION, data, out);
        if(out[0][0]>threshold)executeSell();}
     if(maFast[1]>maSlow[1]&&maFast[0]<maSlow[0]&&sellpos == buypos){
        getData();
        OnnxRun(lstmHandle, ONNX_NO_CONVERSION, data, out);
        if(out[0][0]>threshold)executeBuy();}
     if(buypos>0&&(!PositionSelectByTicket(buypos)|| PositionGetInteger(POSITION_MAGIC) != Magic)){
      buypos = 0;
      }
     if(sellpos>0&&(!PositionSelectByTicket(sellpos)|| PositionGetInteger(POSITION_MAGIC) != Magic)){
      sellpos = 0;
      }
    }
 }

//+------------------------------------------------------------------+
//| Expert trade transaction handling function                       |
//+------------------------------------------------------------------+
void OnTradeTransaction(const MqlTradeTransaction& trans, const MqlTradeRequest& request, const MqlTradeResult& result) {
    if (trans.type == TRADE_TRANSACTION_ORDER_ADD) {
        COrderInfo order;
        if (order.Select(trans.order)) {
            if (order.Magic() == Magic) {
                if (order.OrderType() == ORDER_TYPE_BUY) {
                    buypos = order.Ticket();
                } else if (order.OrderType() == ORDER_TYPE_SELL) {
                    sellpos = order.Ticket();
                }
            }
        }
    }
}

//+------------------------------------------------------------------+
//| Execute sell trade function                                       |
//+------------------------------------------------------------------+
void executeSell() {      
       double bid = SymbolInfoDouble(_Symbol, SYMBOL_BID);
       bid = NormalizeDouble(bid,_Digits);
       trade.Sell(lott,_Symbol,bid);  
       sellpos = trade.ResultOrder();  
       }
    
//+------------------------------------------------------------------+
//| Execute buy trade function                                       |
//+------------------------------------------------------------------+
void executeBuy() {
       double ask = SymbolInfoDouble(_Symbol, SYMBOL_ASK);
       ask = NormalizeDouble(ask,_Digits);
       trade.Buy(lott,_Symbol,ask);
       buypos = trade.ResultOrder();

}

void getData(){
     double rsi[];
     double adx[];
     CopyBuffer(handleAdx,0,1,5,adx);
     CopyBuffer(handleRsi,0,1,5,rsi);
     for (int i =0; i<5; i++){
     data[0][i][0] = (float)adx[i]; 
     data[0][i][1] = (float)rsi[i]; 
     data[0][i][2] = (float)((iClose(_Symbol,PERIOD_CURRENT,5-i)-iOpen(_Symbol,PERIOD_CURRENT,5-i))/iClose(_Symbol,PERIOD_CURRENT,5-i));
     }
}