//+------------------------------------------------------------------+
//|                                 GBPUSD BB Breakout Benchmark.mq5 |
//|                                               Gamuchirai Ndawana |
//|                    https://www.mql5.com/en/users/gamuchiraindawa |
//+------------------------------------------------------------------+
#property copyright "Gamuchirai Ndawana"
#property link      "https://www.mql5.com/en/users/gamuchiraindawa"
#property version   "1.00"

//+------------------------------------------------------------------+
//| System constants                                                 |
//+------------------------------------------------------------------+
#define BB_SHIFT  0                         // Our bollinger band should not be shifted
#define SYMBOL    "GBPUSD"                  // The intended pair for our trading system
#define BB_PRICE  PRICE_CLOSE               // The price our bollinger band should work on
#define LOT       0.1                       // Our intended lot size

//+------------------------------------------------------------------+
//| Dependencies                                                     |
//+------------------------------------------------------------------+
#include <Trade\Trade.mqh>
CTrade Trade;

//+------------------------------------------------------------------+
//| User inputs                                                      |
//+------------------------------------------------------------------+
input group "Technical Indicators"
input ENUM_TIMEFRAMES TF = PERIOD_M15;   // Intended time frame
input int    BB_PERIOD   = 30;               // The period for our bollinger bands
input double BB_SD       = 2.0;              // The standard deviation for our bollinger bands

//+------------------------------------------------------------------+
//| Global variables                                                 |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Technical indicators                                             |
//+------------------------------------------------------------------+
int    bb_handler;
double bb_u[],bb_m[],bb_l[];

//+------------------------------------------------------------------+
//| System variables                                                 |
//+------------------------------------------------------------------+
int state;
double o,h,l,c,bid,ask;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- Setup our system
   if(!setup())
      return(INIT_FAILED);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//--- Release resources we no longer need
   release();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//--- Update our system variables
   update();
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Custom functions                                                 |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Setup our technical indicators and other variables               |
//+------------------------------------------------------------------+
bool setup(void)
  {
//--- Setup our system
   bb_handler = iBands(SYMBOL,TF,BB_PERIOD,BB_SHIFT,BB_SD,BB_PRICE);
   state = 0;

//--- Validate our system has been setup correctly
   if((bb_handler != INVALID_HANDLE) && (Symbol() == SYMBOL))
      return(true);

//--- Something went wrong!
   return(false);
  }

//+------------------------------------------------------------------+
//| Release the resources we no longer need                          |
//+------------------------------------------------------------------+
void release(void)
  {
//--- Free up system resources for our end user
   IndicatorRelease(bb_handler);
  }

//+------------------------------------------------------------------+
//| Update our system variables                                      |
//+------------------------------------------------------------------+
void update(void)
  {
   static datetime timestamp;
   datetime current_time = iTime(Symbol(),PERIOD_CURRENT,0);

   if(timestamp != current_time)
     {
      timestamp = current_time;
      //--- Update our system
      CopyBuffer(bb_handler,0,1,1,bb_m);
      CopyBuffer(bb_handler,1,1,1,bb_u);
      CopyBuffer(bb_handler,2,1,1,bb_l);
      Comment("U: ",bb_u[0],"\nM: ",bb_m[0],"\nL: ",bb_l[0]);

      //--- Market prices
      o = iOpen(SYMBOL,PERIOD_CURRENT,1);
      c = iClose(SYMBOL,PERIOD_CURRENT,1);
      h = iHigh(SYMBOL,PERIOD_CURRENT,1);
      l = iLow(SYMBOL,PERIOD_CURRENT,1);
      bid = SymbolInfoDouble(SYMBOL,SYMBOL_BID);
      ask = SymbolInfoDouble(SYMBOL,SYMBOL_ASK);

      //--- Should we reset our system state?
      if(PositionsTotal() == 0)
        {
         state = 0;
         find_setup();
        }

      if(PositionsTotal() == 1)
        {
         manage_setup();
        }

     }
  }


//+------------------------------------------------------------------+
//| Find an oppurtunity to trade                                     |
//+------------------------------------------------------------------+
void find_setup(void)
  {
//--- Check if we have breached the bollinger bands
   if(c > bb_u[0])
     {
      Trade.Sell(LOT,SYMBOL,bid);
      state = -1;
      return;
     }

   if(c < bb_l[0])
     {
      Trade.Buy(LOT,SYMBOL,ask);
      state = 1;
     }
  }

//+------------------------------------------------------------------+
//| Manage our open trades                                           |
//+------------------------------------------------------------------+
void manage_setup(void)
  {
   if(((c < bb_l[0]) && (state == -1))||((c > bb_u[0]) && (state == 1)))
      Trade.PositionClose(SYMBOL);
  }
//+------------------------------------------------------------------+
