//+------------------------------------------------------------------+
//|                                              SignalAwesome.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of Bill-Williams Accelerator Oscillator Patterns.  |
//| Type=SignalAdvanced                                              |
//| Name=Accelerator                                                 |
//| ShortName=Accelerator                                            |
//| Class=CSignalAccelerator                                         |
//| Page=signal_accelerator                                          |
//| Parameter=Pattern_0,int,50,Pattern 0                             |
//| Parameter=Pattern_1,int,50,Pattern 1                             |
//| Parameter=Pattern_2,int,50,Pattern 2                             |
//| Parameter=Pattern_3,int,50,Pattern 3                             |
//| Parameter=Pattern_4,int,50,Pattern 4                             |
//| Parameter=Pattern_5,int,50,Pattern 5                             |
//| Parameter=Pattern_6,int,50,Pattern 6                             |
//| Parameter=Pattern_7,int,50,Pattern 7                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalAccelerator.                                        |
//| Purpose: Class of generator of trade signals based on            |
//|          Bill-Williams Accelerator oscillator Patterns.          |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
class CSignalAccelerator : public CExpertSignal
{
protected:
   CiAC              m_ac;
   CiMA              m_ma;
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_0;      // model 0 "Zero-Line Crossover"
   int               m_pattern_1;      // model 1 "Consecutive One-sided Single-Colored Bars"
   int               m_pattern_2;      // model 2 "Divergence Between AC and Price"
   int               m_pattern_3;      // model 3 "Reversal Signal Near Zero"
   int               m_pattern_4;      // model 4 "Decreasing Colored-Bar Size"
   int               m_pattern_5;      // model 5 "AC Peaks and Troughs"
   int               m_pattern_6;      // model 6 "Color Change After a Strong Trend"
   int               m_pattern_7;      // model 7 "Flat AC Near Extreme Levels"
   //
   //int               m_patterns_usage;   //

public:
                     CSignalAccelerator(void);
                    ~CSignalAccelerator(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_0(int value)
   {  m_pattern_0 = value;
   }
   void              Pattern_1(int value)
   {  m_pattern_1 = value;
   }
   void              Pattern_2(int value)
   {  m_pattern_2 = value;
   }
   void              Pattern_3(int value)
   {  m_pattern_3 = value;
   }
   void              Pattern_4(int value)
   {  m_pattern_4 = value;
   }
   void              Pattern_5(int value)
   {  m_pattern_5 = value;
   }
   void              Pattern_6(int value)
   {  m_pattern_6 = value;
   }
   void              Pattern_7(int value)
   {  m_pattern_7 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_usage = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void);
   virtual int       ShortCondition(void);

protected:
   //--- method of initialization of the oscillator
   bool              InitAwesome(CIndicators *indicators);
   //--- methods of getting data
   double            AC(int ind)
   {  //
      m_ac.Refresh(-1);
      return(m_ac.Main(ind));
   }
   //
   color             UpperColor(int ind)
   {  //
      return(AC(ind) > 0.0 ? (AC(ind) >= AC(ind + 1) ? clrGreen : clrRed) : clrNONE);
   }
   color             LowerColor(int ind)
   {  //
      return(AC(ind) < 0.0 ? (AC(ind) <= AC(ind + 1) ? clrRed : clrGreen) : clrNONE);
   }
   //
   double            MA(int ind)
   {  //
      m_ma.Refresh(-1);
      return(m_ma.Main(ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_0(ENUM_POSITION_TYPE T);
   bool              IsPattern_1(ENUM_POSITION_TYPE T);
   bool              IsPattern_2(ENUM_POSITION_TYPE T);
   bool              IsPattern_3(ENUM_POSITION_TYPE T);
   bool              IsPattern_4(ENUM_POSITION_TYPE T);
   bool              IsPattern_5(ENUM_POSITION_TYPE T);
   bool              IsPattern_6(ENUM_POSITION_TYPE T);
   bool              IsPattern_7(ENUM_POSITION_TYPE T);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalAccelerator::CSignalAccelerator(void) : m_pattern_0(50),
   m_pattern_1(50),
   m_pattern_2(50),
   m_pattern_3(50),
   m_pattern_4(50),
   m_pattern_5(50),
   m_pattern_6(50),
   m_pattern_7(50)
   //m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE;
   PatternsUsage(m_patterns_usage);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalAccelerator::~CSignalAccelerator(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalAccelerator::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalAccelerator::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitAwesome(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalAccelerator::InitAwesome(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_ac)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object
   if(!m_ac.Create(m_symbol.Name(), m_period))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_ma.Create(m_symbol.Name(), m_period, 8, 0, MODE_SMA, PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalAccelerator::LongCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used and "Zero-Line Crossover"
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_BUY))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used and "Consecutive One-sided Single-Colored Bars"
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_BUY))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used and "Divergence Between AC and Price"
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_BUY))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used and "Reversal Signal Near Zero"
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_BUY))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used and "Decreasing Colored-Bar Size"
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_BUY))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used and "AC Peaks and Troughs"
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_BUY))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used and "Color Change After a Strong Trend"
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_BUY))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used and "Flat AC Near Extreme Levels"
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_BUY))
   {  result += m_pattern_7;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalAccelerator::ShortCondition(void)
{  int result  = 0, results = 0;
//--- if the model 0 is used and "Zero-Line Crossover"
   if(((m_patterns_usage & 0x01) != 0) && IsPattern_0(POSITION_TYPE_SELL))
   {  result += m_pattern_0;
      results++;
   }
//--- if the model 1 is used and "Consecutive One-sided Single-Colored Bars"
   if(((m_patterns_usage & 0x02) != 0) && IsPattern_1(POSITION_TYPE_SELL))
   {  result += m_pattern_1;
      results++;
   }
//--- if the model 2 is used and "Divergence Between AC and Price"
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_SELL))
   {  result += m_pattern_2;
      results++;
   }
//--- if the model 3 is used and "Reversal Signal Near Zero"
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_SELL))
   {  result += m_pattern_3;
      results++;
   }
//--- if the model 4 is used and "Decreasing Colored-Bar Size"
   if(((m_patterns_usage & 0x10) != 0) && IsPattern_4(POSITION_TYPE_SELL))
   {  result += m_pattern_4;
      results++;
   }
//--- if the model 5 is used and "AC Peaks and Troughs"
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_SELL))
   {  result += m_pattern_5;
      results++;
   }
//--- if the model 6 is used and "Color Change After a Strong Trend"
   if(((m_patterns_usage & 0x40) != 0) && IsPattern_6(POSITION_TYPE_SELL))
   {  result += m_pattern_6;
      results++;
   }
//--- if the model 7 is used and "Flat AC Near Extreme Levels"
   if(((m_patterns_usage & 0x80) != 0) && IsPattern_7(POSITION_TYPE_SELL))
   {  result += m_pattern_7;
      results++;
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 0.                                             |
//+------------------------------------------------------------------+
bool CSignalAccelerator::IsPattern_0(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && AC(X() + 1) < 0.0 && AC(X()) > 0.0)
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && AC(X() + 1) > 0.0 && AC(X()) < 0.0)
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 1.                                             |
//+------------------------------------------------------------------+
bool CSignalAccelerator::IsPattern_1(ENUM_POSITION_TYPE T)
{  int _i = X();
   if(T == POSITION_TYPE_BUY && UpperColor(_i) == clrGreen && UpperColor(_i + 1) == clrGreen && UpperColor(_i + 2) == clrGreen)
   {  return(true);               
   }
   else if(T == POSITION_TYPE_SELL && LowerColor(_i) == clrRed && LowerColor(_i + 1) == clrRed && LowerColor(_i + 2) == clrRed)
   {  return(true);               
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 2.                                             |
//+------------------------------------------------------------------+
bool CSignalAccelerator::IsPattern_2(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Low(X() + 3) > Low(X()) && AC(X() + 3) < AC(X()))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && High(X() + 3) < High(X()) && AC(X() + 3) > AC(X()))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 3.                                             |
//+------------------------------------------------------------------+
bool CSignalAccelerator::IsPattern_3(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && AC(X() + 2) > AC(X() + 1) && AC(X() + 1) > 0.0 && AC(X() + 1) < AC(X()))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && AC(X() + 2) < AC(X() + 1) && AC(X() + 1) < 0.0 && AC(X() + 1) > AC(X()))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 4.                                             |
//+------------------------------------------------------------------+
bool CSignalAccelerator::IsPattern_4(ENUM_POSITION_TYPE T)
{  int _i = X();
   if(T == POSITION_TYPE_BUY && LowerColor(_i) == clrGreen && LowerColor(_i + 1) == clrGreen && LowerColor(_i + 2) == clrGreen)
   {  return(true);               
   }
   else if(T == POSITION_TYPE_SELL && UpperColor(_i) == clrRed && UpperColor(_i + 1) == clrRed && UpperColor(_i + 2) == clrRed)
   {  return(true);               
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 5.                                             |
//+------------------------------------------------------------------+
bool CSignalAccelerator::IsPattern_5(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Close(X() + 2) < Close(X() + 1) && Close(X() + 1) > Close(X()) && UpperColor(X()) == clrGreen && AC(X()) > 0.0)
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && Close(X() + 2) > Close(X() + 1) && Close(X() + 1) < Close(X()) && LowerColor(X()) == clrRed && AC(X()) < 0.0)
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 6.                                             |
//+------------------------------------------------------------------+
bool CSignalAccelerator::IsPattern_6(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && ((UpperColor(X() + 1) == clrRed && UpperColor(X()) == clrGreen) || (LowerColor(X() + 1) == clrRed && LowerColor(X()) == clrGreen)))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && ((UpperColor(X() + 1) == clrGreen && UpperColor(X()) == clrRed) || (LowerColor(X() + 1) == clrGreen && LowerColor(X()) == clrRed)))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 7.                                             |
//+------------------------------------------------------------------+
bool CSignalAccelerator::IsPattern_7(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && LowerColor(X() + 3) == clrRed && LowerColor(X() + 2) == clrRed && LowerColor(X() + 1) == clrRed && LowerColor(X()) == clrGreen)
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && UpperColor(X() + 3) == clrGreen && UpperColor(X() + 2) == clrGreen && UpperColor(X() + 1) == clrGreen && UpperColor(X()) == clrRed)
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
