//+------------------------------------------------------------------+
//|                                                    CTimeByDay.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
#include "TimeByMinute.mqh"
#include "TimeByHours/TimeByH1.mqh"
#include "TimeByHours/TimeByH2.mqh"
#include "TimeByHours/TimeByH3.mqh"
#include "TimeByHours/TimeByH4.mqh"
#include "TimeByHours/TimeByH5.mqh"
#include "TimeByHours/TimeByH6.mqh"
#include "TimeByHours/TimeByH7.mqh"
#include "TimeByHours/TimeByH8.mqh"
#include "TimeByHours/TimeByH9.mqh"
#include "TimeByHours/TimeByH10.mqh"
#include "TimeByHours/TimeByH11.mqh"
#include "TimeByHours/TimeByH12.mqh"
#include "TimeByHours/TimeByH13.mqh"
#include "TimeByHours/TimeByH14.mqh"
#include "TimeByHours/TimeByH15.mqh"
#include "TimeByHours/TimeByH16.mqh"
#include "TimeByHours/TimeByH17.mqh"
#include "TimeByHours/TimeByH18.mqh"
#include "TimeByHours/TimeByH19.mqh"
#include "TimeByHours/TimeByH20.mqh"
#include "TimeByHours/TimeByH21.mqh"
#include "TimeByHours/TimeByH22.mqh"
#include "TimeByHours/TimeByH23.mqh"
#include "TimeByHours/TimeByH24.mqh"

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CTimeByDay
  {
private:
   void              Clear();
   TimeByH1          CTBH1;
   TimeByH2          CTBH2;
   TimeByH3          CTBH3;
   TimeByH4          CTBH4;
   TimeByH5          CTBH5;
   TimeByH6          CTBH6;
   TimeByH7          CTBH7;
   TimeByH8          CTBH8;
   TimeByH9          CTBH9;
   TimeByH10         CTBH10;
   TimeByH11         CTBH11;
   TimeByH12         CTBH12;
   TimeByH13         CTBH13;
   TimeByH14         CTBH14;
   TimeByH15         CTBH15;
   TimeByH16         CTBH16;
   TimeByH17         CTBH17;
   TimeByH18         CTBH18;
   TimeByH19         CTBH19;
   TimeByH20         CTBH20;
   TimeByH21         CTBH21;
   TimeByH22         CTBH22;
   TimeByH23         CTBH23;
   TimeByH24         CTBH24;
   CTimeManagement   CTime;
public:
                     CTimeByDay() {}
   void              SetmyTime(Calendar &myNews[]);
   void              GetmyTime(HOURLY myHour,MINUTELY myMinute,
                               TimeDate &TimeData[],Calendar &Events[]);
                    ~CTimeByDay() {}
  };

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CTimeByDay::SetmyTime(Calendar &myNews[])
  {
   Clear();
   ArrayRemove(myTimeData,0,WHOLE_ARRAY);
   ArrayRemove(myEvents,0,WHOLE_ARRAY);
   for(uint i=0;i<myNews.Size();i++)
     {
      datetime Date = datetime(myNews[i].EventDate);
      HOURLY myHour = CTV.Hourly(CTime.ReturnHour(Date));
      MINUTELY myMinute = CTV.Minutely(CTime.ReturnMinute(Date));
      switch(myHour)
        {
         case  H1:
            CTBH1.SetmyTime(myMinute,myNews[i]);
            break;
         case H2:
            CTBH2.SetmyTime(myMinute,myNews[i]);
            break;
         case H3:
            CTBH3.SetmyTime(myMinute,myNews[i]);
            break;
         case H4:
            CTBH4.SetmyTime(myMinute,myNews[i]);
            break;
         case H5:
            CTBH5.SetmyTime(myMinute,myNews[i]);
            break;
         case H6:
            CTBH6.SetmyTime(myMinute,myNews[i]);
            break;
         case H7:
            CTBH7.SetmyTime(myMinute,myNews[i]);
            break;
         case H8:
            CTBH8.SetmyTime(myMinute,myNews[i]);
            break;
         case H9:
            CTBH9.SetmyTime(myMinute,myNews[i]);
            break;
         case H10:
            CTBH10.SetmyTime(myMinute,myNews[i]);
            break;
         case H11:
            CTBH11.SetmyTime(myMinute,myNews[i]);
            break;
         case H12:
            CTBH12.SetmyTime(myMinute,myNews[i]);
            break;
         case H13:
            CTBH13.SetmyTime(myMinute,myNews[i]);
            break;
         case H14:
            CTBH14.SetmyTime(myMinute,myNews[i]);
            break;
         case H15:
            CTBH15.SetmyTime(myMinute,myNews[i]);
            break;
         case H16:
            CTBH16.SetmyTime(myMinute,myNews[i]);
            break;
         case H17:
            CTBH17.SetmyTime(myMinute,myNews[i]);
            break;
         case H18:
            CTBH18.SetmyTime(myMinute,myNews[i]);
            break;
         case H19:
            CTBH19.SetmyTime(myMinute,myNews[i]);
            break;
         case H20:
            CTBH20.SetmyTime(myMinute,myNews[i]);
            break;
         case H21:
            CTBH21.SetmyTime(myMinute,myNews[i]);
            break;
         case H22:
            CTBH22.SetmyTime(myMinute,myNews[i]);
            break;
         case H23:
            CTBH23.SetmyTime(myMinute,myNews[i]);
            break;
         default:
            CTBH24.SetmyTime(myMinute,myNews[i]);
            break;
        }
     }
  }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CTimeByDay::GetmyTime(HOURLY myHour,MINUTELY myMinute,TimeDate &TimeData[],
                           Calendar &Events[])
  {
   switch(myHour)
     {
      case  H1:
         CTBH1.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H2:
         CTBH2.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H3:
         CTBH3.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H4:
         CTBH4.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H5:
         CTBH5.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H6:
         CTBH6.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H7:
         CTBH7.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H8:
         CTBH8.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H9:
         CTBH9.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H10:
         CTBH10.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H11:
         CTBH11.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H12:
         CTBH12.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H13:
         CTBH13.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H14:
         CTBH14.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H15:
         CTBH15.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H16:
         CTBH16.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H17:
         CTBH17.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H18:
         CTBH18.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H19:
         CTBH19.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H20:
         CTBH20.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H21:
         CTBH21.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H22:
         CTBH22.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      case H23:
         CTBH23.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
      default:
         CTBH24.GetTimeData(myHour,myMinute,TimeData,Events);
         break;
     }
  }

//+------------------------------------------------------------------+
//|Clear Data in Array Objects                                       |
//+------------------------------------------------------------------+
void CTimeByDay::Clear(void)
  {
   CTBH1.Clear();
   CTBH2.Clear();
   CTBH3.Clear();
   CTBH4.Clear();
   CTBH5.Clear();
   CTBH6.Clear();
   CTBH7.Clear();
   CTBH8.Clear();
   CTBH9.Clear();
   CTBH10.Clear();
   CTBH11.Clear();
   CTBH12.Clear();
   CTBH13.Clear();
   CTBH14.Clear();
   CTBH15.Clear();
   CTBH16.Clear();
   CTBH17.Clear();
   CTBH18.Clear();
   CTBH19.Clear();
   CTBH20.Clear();
   CTBH21.Clear();
   CTBH22.Clear();
   CTBH23.Clear();
   CTBH24.Clear();
  }
//+------------------------------------------------------------------+
