//+------------------------------------------------------------------+
//|                                                      NewsTrading |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                            https://www.mql5.com/en/users/kaaiblo |
//+------------------------------------------------------------------+
#include "ObjectProperties.mqh"
#include "RiskManagement.mqh"
#include "CommonVariables.mqh"
#include "News.mqh"
//+------------------------------------------------------------------+
//|CommonGraphics class                                              |
//+------------------------------------------------------------------+
class CCommonGraphics:CObjectProperties
  {
private:
   //--- GraphicText structure this structure is responsible for managing the graphical text
   struct GraphicText
     {
      //--- private declaration for struct GraphicText
   private:
      //--- this structure will store properties for the subtext
      struct subtextformat
        {
         string      Label;//Store text label
         string      Text;//Store text value
        };
      //--- this structure inherits from subtextformat and is responsible for finding text
      struct found:subtextformat
        {
         bool        isFound;//Check if text is found
         int         index;//Get index for the text
        };
      //--- structure array for subtexts
      subtextformat  sub_text[];
      //--- function to find text properties from text's label
      found          FoundText(string label)
        {
         found find;
         find.Label="";
         find.Text="";
         find.isFound=false;
         find.index=-1;
         for(uint i=0;i<sub_text.Size();i++)
           {
            //--- If text label is found in array
            if(label==sub_text[i].Label)
              {
               //--- Assign text properties
               find.Label=sub_text[i].Label;
               find.Text=sub_text[i].Text;
               find.isFound=true;
               find.index=int(i);
               return find;//return found text properties
              }
           }
         return find;//return text properties
        }
      //--- public declaration for struct GraphicText
   public:
      //--- string variable
      string         text;
      //--- function to set/add text properties
      void           subtext(string label,string value)
        {
         //--- Get text properties from label
         found result = FoundText(label);
         //--- Check if text label was found/exists in array sub_text
         if(!result.isFound)
           {
            //--- Resize array sub_text
            ArrayResize(sub_text,sub_text.Size()+1,sub_text.Size()+2);
            //--- Add text properties for new array index
            sub_text[sub_text.Size()-1].Label = label;
            sub_text[sub_text.Size()-1].Text = value;
           }
         else
           {
            /* Set new text/override text from text label that exists
            in the array sub_text array */
            sub_text[result.index].Text = value;
           }
        }
      //--- function to retrieve text from text label
      string         subtext(string label)
        {
         return FoundText(label).Text;
        }
     };// End of struct GraphicText

   //--- AccountInfo object declaration
   CAccountInfo      CAccount;
   //--- News object declaration
   CNews             NewsObj;
   //--- TimeManagement object declaration
   CTimeManagement   CTime;
   //--- Calendar structure array declaration
   Calendar          CalendarArray[];
   //--- color variable declaration
   color             EventColor;
   //--- unit variable declarations
   uint              Fontsize,X_start,Y_start;
   //--- void function declarations for Graphical blocks
   void              Block_1();
   void              Block_2(uint SecondsPreEvent=5);
   CRiskManagement   CRisk;//Risk management class object
   //--- GraphicText structure array declarations
   GraphicText       Texts_Block1[9],Texts_Block2[7];
   //--- structure to store text height and width
   struct Text_Prop_Size
     {
      uint           Height;//store text height
      uint           Width;//store text width
     };

   //--- void function to retrieve sum of the texts height and the maximum width of texts from GraphicText array Texts
   void              GetTextMaxWidthAndHeight(GraphicText &Texts[],uint &Max_Height,uint &Max_Width,uint FontSize)
     {
      //--- set fontsize properties to get accurate text height and width sizes
      TextSetFont("Arial",(-1*FontSize)-100);
      //--- set variables to default value of zero
      Max_Height=0;
      Max_Width=0;
      //--- loop through all texts in the GraphicText array Texts
      for(uint i=0;i<Texts.Size();i++)
        {
         //--- temporary declarations for height and width
         uint Height=0,Width=0;
         //--- retrieve text height and width from index in Texts array
         TextGetSize(Texts[i].text,Width,Height);
         //--- sum texts height to variable Max_Height
         Max_Height+=Height;
         //--- assign width if text width is more than variable Max_Width value
         Max_Width=(Width>Max_Width)?Width:Max_Width;
        }
     }
   //--- function to retrieve text height and width properties in the structure Text_Prop_Size format
   Text_Prop_Size    GetText(string Text,uint FontSize)
     {
      //--- structure Text_Prop_Size variable
      Text_Prop_Size Size;
      //--- set fontsize properties to get accurate text height and width sizes
      TextSetFont("Arial",(-1*FontSize)-100);
      //--- retrieve text height and width from Text string variable
      TextGetSize(Text,Size.Width,Size.Height);
      //--- return structure Text_Prop_Size variable
      return Size;
     }
   //--- Function to get texts height sum and max width in the structure Text_Prop_Size format
   Text_Prop_Size    GetTextMax(GraphicText &Texts[],uint FontSize)
     {
      //--- structure Text_Prop_Size variable
      Text_Prop_Size Size;
      //--- uint variable declarations for text properties
      uint Max_Height;
      uint Max_Width;
      //--- Retrieve sum of texts height and maximum texts width into Max_Height,Max_Width
      GetTextMaxWidthAndHeight(Texts,Max_Height,Max_Width,FontSize);
      //--- assign values into structure Text_Prop_Size variable
      Size.Height = Max_Height;
      Size.Width = Max_Width;
      //--- return structure Text_Prop_Size variable
      return Size;
     }
   //--- Boolean declarations
   bool              is_date,is_spread,is_news,is_events;

public:
   //--- class constructor
                     CCommonGraphics(bool display_date,bool display_spread,bool display_news,bool display_events);
                    ~CCommonGraphics(void) {}//class destructor
   void              GraphicsRefresh(uint SecondsPreEvent=5);//will create/refresh the chart objects
   //--- will update certain graphics at an interval
   void              Block_2_Realtime(uint SecondsPreEvent=5);
   //--- will create chart event objects
   void              NewsEvent();
  };

//+------------------------------------------------------------------+
//|Constructor                                                       |
//+------------------------------------------------------------------+
CCommonGraphics::CCommonGraphics(bool display_date,bool display_spread,bool display_news,bool display_events):
//--- Assign variables
   is_date(display_date),is_spread(display_spread),is_news(display_news),is_events(display_events)
  {
//--- get next news event
   NewsObject.EconomicNextEvent();
  }

//+------------------------------------------------------------------+
//|will create/refresh the chart objects                             |
//+------------------------------------------------------------------+
void CCommonGraphics::GraphicsRefresh(uint SecondsPreEvent=5)
  {
//--- create graphics if outside the strategy tester or in the strategy tester and visual mode is enabled
   if((!MQLInfoInteger(MQL_TESTER))||(MQLInfoInteger(MQL_TESTER)&&MQLInfoInteger(MQL_VISUAL_MODE)))
     {
      //--- Delete chart objects
      DeleteObj();//function from Object properties class
      Block_1();//Create graphics for block 1
      //--- Check whether to create graphics for block 2
      if(is_date||is_news||is_spread)
        {
         Block_2(SecondsPreEvent);//Create graphics for block 2
        }
      //--- creates event objects
      NewsEvent();
     }
  }

//+------------------------------------------------------------------+
//|Graphical Block 1                                                 |
//+------------------------------------------------------------------+
void CCommonGraphics::Block_1()
  {
//--- Set text object color depending if the chart color mode is LightMode or not
   TextObj_color = (isLightMode)?clrBlack:clrWheat;
//--- Set text properties for Symbol name,Symbol period and Symbol description # section 1
   Texts_Block1[0].text = Symbol()+", "+GetChartPeriodName()+": "+CSymbol.Description();//set main text
   Texts_Block1[0].subtext("Symbol Name",Symbol()+",");//set subtext - label,value
   Texts_Block1[0].subtext("Symbol Period",GetChartPeriodName());//set subtext - label,value
   Texts_Block1[0].subtext("Symbol Desc",": "+CSymbol.Description());//set subtext - label,value
//--- Set text properties for Contract size # section 2
   Texts_Block1[1].text = "Contract Size: "+string(CSymbol.ContractSize());//set main text
   Texts_Block1[1].subtext("Contract Size Text","Contract Size:");//set subtext - label,value
   Texts_Block1[1].subtext("Contract Size",string(CSymbol.ContractSize()));//set subtext - label,value
//--- Set text properties for Minimum lot # section 3
   Texts_Block1[2].text = "Minimum Lot: "+string(CSymbol.LotsMin());//set main text
   Texts_Block1[2].subtext("Minimum Lot Text","Minimum Lot:");//set subtext - label,value
   Texts_Block1[2].subtext("Minimum Lot",string(CSymbol.LotsMin()));//set subtext - label,value
//--- Set text properties for Max lot # section 4
   Texts_Block1[3].text = "Max Lot: "+string(CSymbol.LotsMax());//set main text
   Texts_Block1[3].subtext("Max Lot Text","Max Lot:");//set subtext - label,value
   Texts_Block1[3].subtext("Max Lot",string(CSymbol.LotsMax()));//set subtext - label,value
//--- Set text properties for Volume step # section 5
   Texts_Block1[4].text = "Volume Step: "+string(CSymbol.LotsStep());//set main text
   Texts_Block1[4].subtext("Volume Step Text","Volume Step:");//set subtext - label,value
   Texts_Block1[4].subtext("Volume Step",string(CSymbol.LotsStep()));//set subtext - label,value
//--- Set text properties for Volume limit # section 6
   Texts_Block1[5].text = "Volume Limit: "+string(CSymbol.LotsLimit());//set main text
   Texts_Block1[5].subtext("Volume Limit Text","Volume Limit:");//set subtext - label,value
   Texts_Block1[5].subtext("Volume Limit",string(CSymbol.LotsLimit()));//set subtext - label,value
//--- Set text properties for Risk option # section 7
   Texts_Block1[6].text = "Risk Option: "+CRisk.GetRiskOption();//set main text
   Texts_Block1[6].subtext("Risk Option Text","Risk Option:");//set subtext - label,value
   Texts_Block1[6].subtext("Risk Option",CRisk.GetRiskOption());//set subtext - label,value
//--- Set text properties for Risk floor # section 8
   Texts_Block1[7].text = "Risk Floor: "+CRisk.GetRiskFloor();//set main text
   Texts_Block1[7].subtext("Risk Floor Text","Risk Floor:");//set subtext - label,value
   Texts_Block1[7].subtext("Risk Floor",CRisk.GetRiskFloor());//set subtext - label,value
//--- Set text properties for Risk ceiling # section 9
   Texts_Block1[8].text = "Risk Ceiling: "+CRisk.GetRiskCeil();//set main text
   Texts_Block1[8].subtext("Risk Ceiling Text","Risk Ceiling:");//set subtext - label,value
   Texts_Block1[8].subtext("Risk Ceiling",CRisk.GetRiskCeil());//set subtext - label,value

//--- Set basic properties
   Fontsize=10;//Set Fontsize
   X_start=2;//Set X distance
   Y_start=2;//Set Y distance

   /* Create objects # section 1*/
//-- Create the background object for width and height+3 of section 1 text
   Square(0,"Symbol Name background",X_start,Y_start,GetText(Texts_Block1[0].text,Fontsize).Width,
          GetText(Texts_Block1[0].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 1
   TextObj(0,"Symbol Name",Texts_Block1[0].subtext("Symbol Name"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[0].subtext("Symbol Name"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Symbol Period",Texts_Block1[0].subtext("Symbol Period"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[0].subtext("Symbol Period"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Symbol Desc",Texts_Block1[0].subtext("Symbol Desc"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   /* Create objects # section 2*/
   X_start=2;//Reset X distance
   Y_start+=GetText(Texts_Block1[0].text,Fontsize).Height;//Re-adjust Y distance, add height from section 1
//-- Create the background object for width and height+3 of section 2 text
   Square(0,"Symbol Contract Size background",X_start,Y_start,GetText(Texts_Block1[1].text,Fontsize).Width,
          GetText(Texts_Block1[1].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 2
   TextObj(0,"Symbol Contract Size Text",Texts_Block1[1].subtext("Contract Size Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[1].subtext("Contract Size Text"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Symbol Contract Size",Texts_Block1[1].subtext("Contract Size"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   /* Create objects # section 3*/
   X_start=2;//Reset X distance
   Y_start+=GetText(Texts_Block1[1].text,Fontsize).Height;//Re-adjust Y distance, add height from section 2
//-- Create the background object for width and height+3 of section 3 text
   Square(0,"Symbol MinLot background",X_start,Y_start,GetText(Texts_Block1[2].text,Fontsize).Width,
          GetText(Texts_Block1[2].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 3
   TextObj(0,"Symbol MinLot Text",Texts_Block1[2].subtext("Minimum Lot Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[2].subtext("Minimum Lot Text"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Symbol MinLot",Texts_Block1[2].subtext("Minimum Lot"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   /* Create objects # section 4*/
   X_start=2;//Reset X distance
   Y_start+=GetText(Texts_Block1[2].text,Fontsize).Height;//Re-adjust Y distance, add height from section 3
//-- Create the background object for width and height+3 of section 4 text
   Square(0,"Symbol MaxLot background",X_start,Y_start,GetText(Texts_Block1[3].text,Fontsize).Width,
          GetText(Texts_Block1[3].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 4
   TextObj(0,"Symbol MaxLot Text",Texts_Block1[3].subtext("Max Lot Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[3].subtext("Max Lot Text"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Symbol MaxLot",Texts_Block1[3].subtext("Max Lot"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   /* Create objects # section 5*/
   X_start=2;//Reset X distance
   Y_start+=GetText(Texts_Block1[3].text,Fontsize).Height;//Re-adjust Y distance, add height from section 4
//-- Create the background object for width and height+3 of section 5 text
   Square(0,"Symbol Volume Step background",X_start,Y_start,GetText(Texts_Block1[4].text,Fontsize).Width,
          GetText(Texts_Block1[4].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 5
   TextObj(0,"Symbol Volume Step Text",Texts_Block1[4].subtext("Volume Step Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[4].subtext("Volume Step Text"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Symbol Volume Step",Texts_Block1[4].subtext("Volume Step"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   /* Create objects # section 6*/
   X_start=2;//Reset X distance
   Y_start+=GetText(Texts_Block1[4].text,Fontsize).Height;//Re-adjust Y distance, add height from section 5
//-- Create the background object for width and height+3 of section 6 text
   Square(0,"Symbol Volume Limit background",X_start,Y_start,GetText(Texts_Block1[5].text,Fontsize).Width,
          GetText(Texts_Block1[5].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 6
   TextObj(0,"Symbol Volume Limit Text",Texts_Block1[5].subtext("Volume Limit Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[5].subtext("Volume Limit Text"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Symbol Volume Limit",Texts_Block1[5].subtext("Volume Limit"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   /* Create objects # section 7*/
   X_start=2;//Reset X distance
   Y_start+=GetText(Texts_Block1[5].text,Fontsize).Height;//Re-adjust Y distance, add height from section 6
//-- Create the background object for width and height+3 of section 7 text
   Square(0,"Risk Option background",X_start,Y_start,GetText(Texts_Block1[6].text,Fontsize).Width,
          GetText(Texts_Block1[6].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 7
   TextObj(0,"Risk Option Text",Texts_Block1[6].subtext("Risk Option Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[6].subtext("Risk Option Text"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Risk Option",Texts_Block1[6].subtext("Risk Option"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   /* Create objects # section 8*/
   X_start=2;//Reset X distance
   Y_start+=GetText(Texts_Block1[6].text,Fontsize).Height;//Re-adjust Y distance, add height from section 7
//-- Create the background object for width and height+3 of section 8 text
   Square(0,"Risk Floor background",X_start,Y_start,GetText(Texts_Block1[7].text,Fontsize).Width,
          GetText(Texts_Block1[7].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 8
   TextObj(0,"Risk Floor Text",Texts_Block1[7].subtext("Risk Floor Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[7].subtext("Risk Floor Text"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Risk Floor",Texts_Block1[7].subtext("Risk Floor"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   /* Create objects # section 9*/
   X_start=2;//Reset X distance
   Y_start+=GetText(Texts_Block1[7].text,Fontsize).Height;//Re-adjust Y distance, add height from section 8
//-- Create the background object for width and height+3 of section 9 text
   Square(0,"Risk Ceil background",X_start,Y_start,GetText(Texts_Block1[8].text,Fontsize).Width,
          GetText(Texts_Block1[8].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
   Y_start+=3;//Re-adjust Y distance
   X_start+=2;//Re-adjust X distance
//-- Will create the text objects for section 9
   TextObj(0,"Risk Ceil Text",Texts_Block1[8].subtext("Risk Ceiling Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
   X_start+=GetText(Texts_Block1[8].subtext("Risk Ceiling Text"),Fontsize).Width;//Re-adjust X distance
   TextObj(0,"Risk Ceil",Texts_Block1[8].subtext("Risk Ceiling"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
  }

//+------------------------------------------------------------------+
//|Graphical Block 2                                                 |
//+------------------------------------------------------------------+
void CCommonGraphics::Block_2(uint SecondsPreEvent=5)
  {
//--- Set text object color depending if the chart color mode is LightMode or not
   TextObj_color=(isLightMode)?clrBlack:clrWheat;
   if(is_date)//Check whether to display date information
     {
      //--- Set text properties for Date and Time # section 10
      Texts_Block2[0].text = "Date:"+TimeToString(TimeTradeServer(),TIME_DATE)+"|| Time:"+TimeToString(TimeTradeServer(),TIME_MINUTES)
                             +"   ";//set main text
      Texts_Block2[0].subtext("Date Text","Date:");//set subtext - label,value
      Texts_Block2[0].subtext("Date",TimeToString(TimeTradeServer(),TIME_DATE));//set subtext - label,value
      Texts_Block2[0].subtext("Time Text","|| Time:");//set subtext - label,value
      Texts_Block2[0].subtext("Time",TimeToString(TimeTradeServer(),TIME_MINUTES));//set subtext - label,value
     }
   if(is_news)//Check whether to display news information
     {
      //--- Set text object color depending on upcoming news event's Importance
      EventColor = NewsObj.GetImportance_color(NewsObj.IMPORTANCE(UpcomingNews.EventImportance));
      //--- Set text properties for Event Date # section 11
      Texts_Block2[1].text = "Event: @"+UpcomingNews.EventDate+" ";//set main text
      Texts_Block2[1].subtext("Event Date Text","Event: @");//set subtext - label,value
      Texts_Block2[1].subtext("Event Date",UpcomingNews.EventDate);//set subtext - label,value
      //--- Set text properties for Event Name # section 12
      Texts_Block2[2].text = "Name: "+UpcomingNews.EventName+" ";//set main text
      Texts_Block2[2].subtext("Event Name Text","Name: ");//set subtext - label,value
      Texts_Block2[2].subtext("Event Name",UpcomingNews.EventName);//set subtext - label,value
      //--- Set text properties for Event Country # section 13
      Texts_Block2[3].text = "Country: "+UpcomingNews.CountryName+" ";//set main text
      Texts_Block2[3].subtext("Event Country Text","Country: ");//set subtext - label,value
      Texts_Block2[3].subtext("Event Country",UpcomingNews.CountryName);//set subtext - label,value
      //--- Set text properties for Event Currency # section 14
      Texts_Block2[4].text = "Currency: "+UpcomingNews.EventCurrency+" ";//set main text
      Texts_Block2[4].subtext("Event Currency Text","Currency: ");//set subtext - label,value
      Texts_Block2[4].subtext("Event Currency",UpcomingNews.EventCurrency);//set subtext - label,value
      //--- Set text properties for Event Importance # section 15
      Texts_Block2[5].text = "Importance: "+NewsObj.GetImportance(NewsObj.IMPORTANCE(UpcomingNews.EventImportance))+" ";//set main text
      Texts_Block2[5].subtext("Importance Text","Importance: ");//set subtext - label,value
      Texts_Block2[5].subtext("Importance",NewsObj.GetImportance(NewsObj.IMPORTANCE(UpcomingNews.EventImportance)));//set subtext - label,value
     }
   if(is_spread)//Check whether to display spread information
     {
      //--- Set text properties for Spread # section 16
      Texts_Block2[6].text = "Spread: "+string(CSymbol.Spread())+" Rating: "+CSymbol.SpreadDesc()+" ";//set main text
      Texts_Block2[6].subtext("Spread Text","Spread:");//set subtext - label,value
      Texts_Block2[6].subtext("Spread",string(CSymbol.Spread()));//set subtext - label,value
      Texts_Block2[6].subtext("Rating Text"," Rating:");//set subtext - label,value
      Texts_Block2[6].subtext("Rating Desc",CSymbol.SpreadDesc());//set subtext - label,value
     }

//--- Set basic properties
   Fontsize=10;
   X_start=2;//Reset X distance
   Y_start=GetTextMax(Texts_Block1,Fontsize).Height+29;//Re-adjust Y distance from graphical block 1 Height

   /* Create objects # section 10*/
   if(is_date)//Check whether to display date information
     {
      //-- Create the background object for width and height+3 of section 10 text
      Square(0,"Datetime background",X_start,Y_start,GetText(Texts_Block2[0].text,Fontsize).Width,
             GetText(Texts_Block2[0].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //-- Will create the text objects for section 10
      TextObj(0,"Date Text",Texts_Block2[0].subtext("Date Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[0].subtext("Date Text"),Fontsize).Width;//Re-adjust X distance
      TextObj(0,"Date",Texts_Block2[0].subtext("Date"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[0].subtext("Date"),Fontsize).Width;//Re-adjust X distance
      TextObj(0,"Time Text",Texts_Block2[0].subtext("Time Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[0].subtext("Time Text"),Fontsize).Width;//Re-adjust X distance
      //--- Adjust text color depending if chart color mode is LightMode and if a news event is occurring
      TextObj_color = CTime.TimeIsInRange(CTime.TimeMinusOffset(datetime(UpcomingNews.EventDate),SecondsPreEvent),
                                          CTime.TimePlusOffset(datetime(UpcomingNews.EventDate),59))?clrRed:(isLightMode)?clrBlack:clrWheat;
      TextObj(0,"Time",Texts_Block2[0].subtext("Time"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
     }
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   if(UpcomingNews.CountryName!=NULL&&is_news)//Check whether to display news information and if upcoming news is available
     {
      /* Create objects # section 11*/
      Y_start+=(is_date)?GetText(Texts_Block2[0].text,Fontsize).Height:0;//Re-adjust Y distance depending if section 10 is shown
      X_start=2;//Reset X distance
      //-- Create the background object for width and height+3 of section 11 text
      Square(0,"Event Date background",X_start,Y_start,GetText(Texts_Block2[1].text,Fontsize).Width,
             GetText(Texts_Block2[1].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will create the text objects for section 11
      TextObj(0,"Event Date Text",Texts_Block2[1].subtext("Event Date Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[1].subtext("Event Date Text"),Fontsize).Width;//Re-adjust X distance
      //--- Adjust text color depending if chart color mode is LightMode and if a news event is occurring
      TextObj_color = CTime.TimeIsInRange(CTime.TimeMinusOffset(datetime(UpcomingNews.EventDate),SecondsPreEvent),
                                          CTime.TimePlusOffset(datetime(UpcomingNews.EventDate),59))?clrRed:(isLightMode)?clrBlack:clrWheat;
      TextObj(0,"Event Date",Texts_Block2[1].subtext("Event Date"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 12*/
      Y_start+=GetText(Texts_Block2[1].text,Fontsize).Height;//Re-adjust Y distance
      X_start=2;//Reset X distance
      //-- Create the background object for width and height+3 of section 12 text
      Square(0,"Event Name background",X_start,Y_start,GetText(Texts_Block2[2].text,Fontsize).Width,
             GetText(Texts_Block2[2].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will create the text objects for section 12
      TextObj(0,"Event Name Text",Texts_Block2[2].subtext("Event Name Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[2].subtext("Event Name Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending on upcoming news event's Importance
      TextObj_color=EventColor;
      TextObj(0,"Event Name",Texts_Block2[2].subtext("Event Name"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 13*/
      Y_start+=GetText(Texts_Block2[2].text,Fontsize).Height;//Re-adjust Y distance
      X_start=2;//Reset X distance
      //-- Create the background object for width and height+3 of section 13 text
      Square(0,"Event Country background",X_start,Y_start,GetText(Texts_Block2[3].text,Fontsize).Width,
             GetText(Texts_Block2[3].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will create the text objects for section 13
      TextObj(0,"Event Country Text",Texts_Block2[3].subtext("Event Country Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[3].subtext("Event Country Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending on upcoming news event's Importance
      TextObj_color=EventColor;
      TextObj(0,"Event Country",Texts_Block2[3].subtext("Event Country"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 14*/
      Y_start+=GetText(Texts_Block2[3].text,Fontsize).Height;//Re-adjust Y distance
      X_start=2;//Reset X distance
      //-- Create the background object for width and height+3 of section 14 text
      Square(0,"Event Currency background",X_start,Y_start,GetText(Texts_Block2[4].text,Fontsize).Width,
             GetText(Texts_Block2[4].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will create the text objects for section 14
      TextObj(0,"Event Currency Text",Texts_Block2[4].subtext("Event Currency Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[4].subtext("Event Currency Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending on upcoming news event's Importance
      TextObj_color=EventColor;
      TextObj(0,"Event Currency",Texts_Block2[4].subtext("Event Currency"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 15*/
      Y_start+=GetText(Texts_Block2[4].text,Fontsize).Height;//Re-adjust Y distance
      X_start=2;//Reset X distance
      //-- Create the background object for width and height+3 of section 15 text
      Square(0,"Event Importance background",X_start,Y_start,GetText(Texts_Block2[5].text,Fontsize).Width,
             GetText(Texts_Block2[5].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will create the text objects for section 15
      TextObj(0,"Importance Text",Texts_Block2[5].subtext("Importance Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[5].subtext("Importance Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending on upcoming news event's Importance
      TextObj_color=EventColor;
      TextObj(0,"Importance",Texts_Block2[5].subtext("Importance"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 16*/
      if(is_spread)//Check whether to display spread information
        {
         Y_start+=GetText(Texts_Block2[5].text,Fontsize).Height;//Re-adjust Y distance
         X_start=2;//Reset X distance
         //-- Create the background object for width and height+3 of section 16 text
         Square(0,"Spread background",X_start,Y_start,GetText(Texts_Block2[6].text,Fontsize).Width,
                GetText(Texts_Block2[6].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
         Y_start+=3;//Re-adjust Y distance
         X_start+=2;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         color Spread_clr=CSymbol.SpreadColor();
         //--- Set text object color depending if the chart color mode is LightMode or not
         TextObj_color=(isLightMode)?clrBlack:clrWheat;
         //-- Will create the text objects for section 16
         TextObj(0,"Symbol Spread Text",Texts_Block2[6].subtext("Spread Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Spread Text"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         TextObj_color=Spread_clr;
         TextObj(0,"Symbol Spread",Texts_Block2[6].subtext("Spread"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Spread"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending if the chart color mode is LightMode or not
         TextObj_color=(isLightMode)?clrBlack:clrWheat;
         TextObj(0,"Symbol Rating Text",Texts_Block2[6].subtext("Rating Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Rating Text"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         TextObj_color=Spread_clr;
         TextObj(0,"Symbol Rating",Texts_Block2[6].subtext("Rating Desc"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
        }
     }
   else
      /* Create objects # section 16*/
      if(is_spread)//Check whether to display spread information
        {
         Y_start+=(is_date)?GetText(Texts_Block2[0].text,Fontsize).Height:0;//Re-adjust Y distance depending if section 10 is shown
         X_start=2;//Reset X distance
         //-- Create the background object for width and height+3 of section 16 text
         Square(0,"Spread background",X_start,Y_start,GetText(Texts_Block2[6].text,Fontsize).Width,
                GetText(Texts_Block2[6].text,Fontsize).Height+3,ANCHOR_LEFT_UPPER);
         Y_start+=3;//Re-adjust Y distance
         X_start+=2;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         color Spread_clr=CSymbol.SpreadColor();
         //--- Set text object color depending if the chart color mode is LightMode or not
         TextObj_color=(isLightMode)?clrBlack:clrWheat;
         //-- Will create the text objects for section 16
         TextObj(0,"Symbol Spread Text",Texts_Block2[6].subtext("Spread Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Spread Text"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         TextObj_color=Spread_clr;
         TextObj(0,"Symbol Spread",Texts_Block2[6].subtext("Spread"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Spread"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending if the chart color mode is LightMode or not
         TextObj_color=(isLightMode)?clrBlack:clrWheat;
         TextObj(0,"Symbol Rating Text",Texts_Block2[6].subtext("Rating Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Rating Text"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         TextObj_color=Spread_clr;
         TextObj(0,"Symbol Rating",Texts_Block2[6].subtext("Rating Desc"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
        }
  }

//+------------------------------------------------------------------+
//|will update certain graphics at an interval                       |
//+------------------------------------------------------------------+
void CCommonGraphics::Block_2_Realtime(uint SecondsPreEvent=5)
  {
   if(MQLInfoInteger(MQL_TESTER)&&!MQLInfoInteger(MQL_VISUAL_MODE))
     {
      return;//exit if in strategy tester and not in visual mode
     }

   if(is_date)//Check whether to display date information
     {
      //--- Set text properties for Date and Time # section 10
      Texts_Block2[0].text = "Date:"+TimeToString(TimeTradeServer(),TIME_DATE)+"|| Time:"+TimeToString(TimeTradeServer(),TIME_SECONDS)
                             +"   ";//set main text
      Texts_Block2[0].subtext("Date Text","Date:");//set subtext - label,value
      Texts_Block2[0].subtext("Date",TimeToString(TimeTradeServer(),TIME_DATE));//set subtext - label,value
      Texts_Block2[0].subtext("Time Text","|| Time:");//set subtext - label,value
      Texts_Block2[0].subtext("Time",TimeToString(TimeTradeServer(),TIME_SECONDS));//set subtext - label,value
     }
   if(is_news)//Check whether to display news information
     {
      //--- Set text object color depending on upcoming news event's Importance
      EventColor = NewsObj.GetImportance_color(NewsObj.IMPORTANCE(UpcomingNews.EventImportance));
      //--- Set text properties for Event Date # section 11
      Texts_Block2[1].text = "Event: @"+UpcomingNews.EventDate+" ";//set main text
      Texts_Block2[1].subtext("Event Date Text","Event: @");//set subtext - label,value
      Texts_Block2[1].subtext("Event Date",UpcomingNews.EventDate);//set subtext - label,value
      //--- Set text properties for Event Name # section 12
      Texts_Block2[2].text = "Name: "+UpcomingNews.EventName+" ";//set main text
      Texts_Block2[2].subtext("Event Name Text","Name: ");//set subtext - label,value
      Texts_Block2[2].subtext("Event Name",UpcomingNews.EventName);//set subtext - label,value
      //--- Set text properties for Event Country # section 13
      Texts_Block2[3].text = "Country: "+UpcomingNews.CountryName+" ";//set main text
      Texts_Block2[3].subtext("Event Country Text","Country: ");//set subtext - label,value
      Texts_Block2[3].subtext("Event Country",UpcomingNews.CountryName);//set subtext - label,value
      //--- Set text properties for Event Currency # section 14
      Texts_Block2[4].text = "Currency: "+UpcomingNews.EventCurrency+" ";//set main text
      Texts_Block2[4].subtext("Event Currency Text","Currency: ");//set subtext - label,value
      Texts_Block2[4].subtext("Event Currency",UpcomingNews.EventCurrency);//set subtext - label,value
      //--- Set text properties for Event Importance # section 15
      Texts_Block2[5].text = "Importance: "+NewsObj.GetImportance(NewsObj.IMPORTANCE(UpcomingNews.EventImportance))+" ";//set main text
      Texts_Block2[5].subtext("Importance Text","Importance: ");//set subtext - label,value
      Texts_Block2[5].subtext("Importance",NewsObj.GetImportance(NewsObj.IMPORTANCE(UpcomingNews.EventImportance)));//set subtext - label,value
     }
   if(is_spread)//Check whether to display spread information
     {
      //--- Set text properties for Spread # section 16
      Texts_Block2[6].text = "Spread: "+string(CSymbol.Spread())+" Rating: "+CSymbol.SpreadDesc()+" ";//set main text
      Texts_Block2[6].subtext("Spread Text","Spread:");//set subtext - label,value
      Texts_Block2[6].subtext("Spread",string(CSymbol.Spread()));//set subtext - label,value
      Texts_Block2[6].subtext("Rating Text"," Rating:");//set subtext - label,value
      Texts_Block2[6].subtext("Rating Desc",CSymbol.SpreadDesc());//set subtext - label,value
     }

//--- Set basic properties
   Fontsize=10;
   X_start=2;//Reset X distance
   Y_start=GetTextMax(Texts_Block1,Fontsize).Height+29;//Re-adjust Y distance from section block 1

   /* Create objects # section 10*/
   if(is_date)//Check whether to display date information
     {
      //-- Check if the background object x-size for section 10 is the same size as section 10 text width
      if(ObjectGetInteger(0,"Datetime background",OBJPROP_XSIZE)!=GetText(Texts_Block2[0].text,Fontsize).Width)
        {
         //-- Will re-adjust background object to any changes of section 10 text width
         ObjectSetInteger(0,"Datetime background",OBJPROP_XSIZE,long(GetText(Texts_Block2[0].text,Fontsize).Width));
        }
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will update the text objects for section 10
      TextObj(0,"Date Text",Texts_Block2[0].subtext("Date Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[0].subtext("Date Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      TextObj(0,"Date",Texts_Block2[0].subtext("Date"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[0].subtext("Date"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      TextObj(0,"Time Text",Texts_Block2[0].subtext("Time Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[0].subtext("Time Text"),Fontsize).Width;//Re-adjust X distance
      //--- Adjust text color depending if chart color mode is LightMode and if a news event is occurring
      TextObj_color = CTime.TimeIsInRange(CTime.TimeMinusOffset(datetime(UpcomingNews.EventDate),SecondsPreEvent),
                                          CTime.TimePlusOffset(datetime(UpcomingNews.EventDate),59))?clrRed:(isLightMode)?clrBlack:clrWheat;
      TextObj(0,"Time",Texts_Block2[0].subtext("Time"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
     }
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   if(UpcomingNews.CountryName!=NULL&&is_news)//Check whether to display news information
     {
      /* Create objects # section 11*/
      Y_start+=(is_date)?GetText(Texts_Block2[0].text,Fontsize).Height:0;
      X_start=2;//Reset X distance
      //-- Check if the background object x-size for section 11 is the same size as section 11 text width
      if(ObjectGetInteger(0,"Event Date background",OBJPROP_XSIZE)!=GetText(Texts_Block2[1].text,Fontsize).Width)
        {
         //-- Will re-adjust background object to any changes of section 11 text width
         ObjectSetInteger(0,"Event Date background",OBJPROP_XSIZE,long(GetText(Texts_Block2[1].text,Fontsize).Width));
        }
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will update the text objects for section 11
      TextObj(0,"Event Date Text",Texts_Block2[1].subtext("Event Date Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[1].subtext("Event Date Text"),Fontsize).Width;//Re-adjust X distance
      //--- Adjust text color depending if chart color mode is LightMode and if a news event is occurring
      TextObj_color = CTime.TimeIsInRange(CTime.TimeMinusOffset(datetime(UpcomingNews.EventDate),SecondsPreEvent),
                                          CTime.TimePlusOffset(datetime(UpcomingNews.EventDate),59))?clrRed:(isLightMode)?clrBlack:clrWheat;
      TextObj(0,"Event Date",Texts_Block2[1].subtext("Event Date"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 12*/
      Y_start+=GetText(Texts_Block2[1].text,Fontsize).Height;//Re-adjust Y distance
      X_start=2;//Reset X distance
      //-- Check if the background object x-size for section 12 is the same size as section 12 text width
      if(ObjectGetInteger(0,"Event Name background",OBJPROP_XSIZE)!=GetText(Texts_Block2[2].text,Fontsize).Width)
        {
         //-- Will re-adjust background object to any changes of section 12 text width
         ObjectSetInteger(0,"Event Name background",OBJPROP_XSIZE,long(GetText(Texts_Block2[2].text,Fontsize).Width));
        }
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will update the text objects for section 12
      TextObj(0,"Event Name Text",Texts_Block2[2].subtext("Event Name Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[2].subtext("Event Name Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending on upcoming news event's Importance
      TextObj_color=EventColor;
      TextObj(0,"Event Name",Texts_Block2[2].subtext("Event Name"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 13*/
      Y_start+=GetText(Texts_Block2[2].text,Fontsize).Height;//Re-adjust Y distance
      X_start=2;//Reset X distance
      //-- Check if the background object x-size for section 13 is the same size as section 13 text width
      if(ObjectGetInteger(0,"Event Country background",OBJPROP_XSIZE)!=GetText(Texts_Block2[3].text,Fontsize).Width)
        {
         //-- Will re-adjust background object to any changes of section 13 text width
         ObjectSetInteger(0,"Event Country background",OBJPROP_XSIZE,long(GetText(Texts_Block2[3].text,Fontsize).Width));
        }
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will update the text objects for section 13
      TextObj(0,"Event Country Text",Texts_Block2[3].subtext("Event Country Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[3].subtext("Event Country Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending on upcoming news event's Importance
      TextObj_color=EventColor;
      TextObj(0,"Event Country",Texts_Block2[3].subtext("Event Country"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 14*/
      Y_start+=GetText(Texts_Block2[3].text,Fontsize).Height;//Re-adjust Y distance
      X_start=2;//Reset X distance
      //-- Check if the background object x-size for section 14 is the same size as section 14 text width
      if(ObjectGetInteger(0,"Event Currency background",OBJPROP_XSIZE)!=GetText(Texts_Block2[4].text,Fontsize).Width)
        {
         //-- Will re-adjust background object to any changes of section 14 text width
         ObjectSetInteger(0,"Event Currency background",OBJPROP_XSIZE,long(GetText(Texts_Block2[4].text,Fontsize).Width));
        }
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will update the text objects for section 14
      TextObj(0,"Event Currency Text",Texts_Block2[4].subtext("Event Currency Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[4].subtext("Event Currency Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending on upcoming news event's Importance
      TextObj_color=EventColor;
      TextObj(0,"Event Currency",Texts_Block2[4].subtext("Event Currency"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 15*/
      Y_start+=GetText(Texts_Block2[4].text,Fontsize).Height;//Re-adjust Y distance
      X_start=2;//Reset X distance
      //-- Check if the background object x-size for section 15 is the same size as section 15 text width
      if(ObjectGetInteger(0,"Event Importance background",OBJPROP_XSIZE)!=GetText(Texts_Block2[5].text,Fontsize).Width)
        {
         //-- Will re-adjust background object to any changes of section 15 text width
         ObjectSetInteger(0,"Event Importance background",OBJPROP_XSIZE,long(GetText(Texts_Block2[5].text,Fontsize).Width));
        }
      Y_start+=3;//Re-adjust Y distance
      X_start+=2;//Re-adjust X distance
      //--- Set text object color depending if the chart color mode is LightMode or not
      TextObj_color=(isLightMode)?clrBlack:clrWheat;
      //-- Will update the text objects for section 15
      TextObj(0,"Importance Text",Texts_Block2[5].subtext("Importance Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      X_start+=GetText(Texts_Block2[5].subtext("Importance Text"),Fontsize).Width;//Re-adjust X distance
      //--- Set text object color depending on upcoming news event's Importance
      TextObj_color=EventColor;
      TextObj(0,"Importance",Texts_Block2[5].subtext("Importance"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      /* Create objects # section 16*/
      if(is_spread)//Check whether to display spread information
        {
         Y_start+=GetText(Texts_Block2[5].text,Fontsize).Height;//Re-adjust Y distance
         X_start=2;//Reset X distance
         //-- Check if the background object x-size for section 16 is the same size as section 16 text width
         if(ObjectGetInteger(0,"Spread background",OBJPROP_XSIZE)!=GetText(Texts_Block2[6].text,Fontsize).Width)
           {
            //-- Will re-adjust background object to any changes of section 16 text width
            ObjectSetInteger(0,"Spread background",OBJPROP_XSIZE,long(GetText(Texts_Block2[6].text,Fontsize).Width));
           }
         Y_start+=3;//Re-adjust Y distance
         X_start+=2;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         color Spread_clr=CSymbol.SpreadColor();
         //-- Will create the text object for the Symbol's name
         X_start+=GetText(Texts_Block2[6].subtext("Spread Text"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         TextObj_color=Spread_clr;
         //-- Will update the text objects for section 16
         TextObj(0,"Symbol Spread",Texts_Block2[6].subtext("Spread"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Spread"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending if the chart color mode is LightMode or not
         TextObj_color=(isLightMode)?clrBlack:clrWheat;
         TextObj(0,"Symbol Rating Text",Texts_Block2[6].subtext("Rating Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Rating Text"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         TextObj_color=Spread_clr;
         TextObj(0,"Symbol Rating",Texts_Block2[6].subtext("Rating Desc"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
        }
     }
   else
      /* Create objects # section 16*/
      if(is_spread)//Check whether to display spread information
        {
         Y_start+=(is_date)?GetText(Texts_Block2[0].text,Fontsize).Height:0;//Re-adjust Y distance
         X_start=2;//Reset X distance
         //-- Check if the background object x-size for section 16 is the same size as section 16 text width
         if(ObjectGetInteger(0,"Spread background",OBJPROP_XSIZE)!=GetText(Texts_Block2[6].text,Fontsize).Width)
           {
            //-- Will re-adjust background object to any changes of section 16 text width
            ObjectSetInteger(0,"Spread background",OBJPROP_XSIZE,long(GetText(Texts_Block2[6].text,Fontsize).Width));
           }
         Y_start+=3;//Re-adjust Y distance
         X_start+=2;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         color Spread_clr=CSymbol.SpreadColor();
         //-- Will create the text object for the Symbol's name
         X_start+=GetText(Texts_Block2[6].subtext("Spread Text"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         TextObj_color=Spread_clr;
         //-- Will update the text objects for section 16
         TextObj(0,"Symbol Spread",Texts_Block2[6].subtext("Spread"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Spread"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending if the chart color mode is LightMode or not
         TextObj_color=(isLightMode)?clrBlack:clrWheat;
         TextObj(0,"Symbol Rating Text",Texts_Block2[6].subtext("Rating Text"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
         X_start+=GetText(Texts_Block2[6].subtext("Rating Text"),Fontsize).Width;//Re-adjust X distance
         //--- Set text object color depending on spread rating
         TextObj_color=Spread_clr;
         TextObj(0,"Symbol Rating",Texts_Block2[6].subtext("Rating Desc"),X_start,Y_start,CORNER_LEFT_UPPER,Fontsize);
        }
  }

//+------------------------------------------------------------------+
//|will create chart event objects                                   |
//+------------------------------------------------------------------+
void CCommonGraphics::NewsEvent()
  {
   if(!is_events||(MQLInfoInteger(MQL_TESTER)&&!MQLInfoInteger(MQL_VISUAL_MODE)))
     {return;}//exit if in strategy tester and not in visual mode or is_events variable is false
//--- Iterate through all events in CalendarArray
   for(uint i=0;i<CalendarArray.Size();i++)
     {
      //--- Create event object with the news properties
      EventObj(0,CalendarArray[i].EventName+" "+CalendarArray[i].CountryName+" "+CalendarArray[i].EventDate,
               CalendarArray[i].EventName+"["+CalendarArray[i].CountryName+"]",StringToTime(CalendarArray[i].EventDate));
     }
//--- Refresh the chart/ update the chart
   ChartRefresh();
  }
//+------------------------------------------------------------------+
