//+------------------------------------------------------------------+
//|                                                      NewsTrading |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                            https://www.mql5.com/en/users/kaaiblo |
//+------------------------------------------------------------------+
//--- Enumeration For Hours in a Day
enum HOURLY
  {
   H1=1,//01
   H2=2,//02
   H3=3,//03
   H4=4,//04
   H5=5,//05
   H6=6,//06
   H7=7,//07
   H8=8,//08
   H9=9,//09
   H10=10,//10
   H11=11,//11
   H12=12,//12
   H13=13,//13
   H14=14,//14
   H15=15,//15
   H16=16,//16
   H17=17,//17
   H18=18,//18
   H19=19,//19
   H20=20,//20
   H21=21,//21
   H22=22,//22
   H23=23,//23
   H24=0//00
  };

//--- Enumeration For Minutes in an Hour
enum MINUTELY
  {
   M0,//00
   M1,//01
   M2,//02
   M3,//03
   M4,//04
   M5,//05
   M6,//06
   M7,//07
   M8,//08
   M9,//09
   M10,//10
   M11,//11
   M12,//12
   M13,//13
   M14,//14
   M15,//15
   M16,//16
   M17,//17
   M18,//18
   M19,//19
   M20,//20
   M21,//21
   M22,//22
   M23,//23
   M24,//24
   M25,//25
   M26,//26
   M27,//27
   M28,//28
   M29,//29
   M30,//30
   M31,//31
   M32,//32
   M33,//33
   M34,//34
   M35,//35
   M36,//36
   M37,//37
   M38,//38
   M39,//39
   M40,//40
   M41,//41
   M42,//42
   M43,//43
   M44,//44
   M45,//45
   M46,//46
   M47,//47
   M48,//48
   M49,//49
   M50,//50
   M51,//51
   M52,//52
   M53,//53
   M54,//54
   M55,//55
   M56,//56
   M57,//57
   M58,//58
   M59//59
  };

//--- Enumeration For Seconds Pre-event datetime
enum PRESECONDLY
  {
   Pre_S30=30//30
  };

//--- Enumeration For Seconds in a Minute
enum SECONDLY
  {
   S0,//00
   S1,//01
   S2,//02
   S3,//03
   S4,//04
   S5,//05
   S6,//06
   S7,//07
   S8,//08
   S9,//09
   S10,//10
   S11,//11
   S12,//12
   S13,//13
   S14,//14
   S15,//15
   S16,//16
   S17,//17
   S18,//18
   S19,//19
   S20,//20
   S21,//21
   S22,//22
   S23,//23
   S24,//24
   S25,//25
   S26,//26
   S27,//27
   S28,//28
   S29,//29
   S30,//30
   S31,//31
   S32,//32
   S33,//33
   S34,//34
   S35,//35
   S36,//36
   S37,//37
   S38,//38
   S39,//39
   S40,//40
   S41,//41
   S42,//42
   S43,//43
   S44,//44
   S45,//45
   S46,//46
   S47,//47
   S48,//48
   S49,//49
   S50,//50
   S51,//51
   S52,//52
   S53,//53
   S54,//54
   S55,//55
   S56,//56
   S57,//57
   S58,//58
   S59//59
  };
//+------------------------------------------------------------------+
//|TimeVariables class                                               |
//+------------------------------------------------------------------+
class CTimeVariables
  {
private:
   //--- Array to store candlestick times
   datetime          CandleTime[2000];
public:
                     CTimeVariables(void);
   //--- Set datetime value for an array index
   void              SetTime(uint index,datetime time);
   //--- Get datetime value for an array index
   datetime          GetTime(uint index);
   //--- Convert Integer to the Enumeration HOURLY
   HOURLY            Hourly(uint Hour);
   //--- Convert Integer to the Enumeration MINUTELY
   MINUTELY          Minutely(uint Minute);
   //--- Convert Integer to the Enumeration SECONDLY
   SECONDLY          Secondly(uint Second);
  };

//+------------------------------------------------------------------+
//|Constructor                                                       |
//+------------------------------------------------------------------+
CTimeVariables::CTimeVariables()
  {
//--- Set default datetime values for all indexes in array CandleTime
   for(uint i=0; i<CandleTime.Size(); i++)
     {
      CandleTime[i]=D'1970.01.01';
     }
  }

//+------------------------------------------------------------------+
//|Set datetime value for an array index in array CandleTime         |
//+------------------------------------------------------------------+
void CTimeVariables::SetTime(uint index,datetime time)
  {
   if(index>=0&&index<CandleTime.Size())
     {
      CandleTime[index] = time;
     }
  }

//+------------------------------------------------------------------+
//|Get the datetime value for an array index in array CandleTime     |
//+------------------------------------------------------------------+
datetime CTimeVariables::GetTime(uint index)
  {
   return (index>=0&&index<CandleTime.Size())?CandleTime[index]:datetime(0);
  }

//+------------------------------------------------------------------+
//|Convert Integer to the Enumeration HOURLY                         |
//+------------------------------------------------------------------+
HOURLY CTimeVariables::Hourly(uint Hour)
  {
   return (Hour>23)?HOURLY(0):HOURLY(Hour);
  }

//+------------------------------------------------------------------+
//|Convert Integer to the Enumeration MINUTELY                       |
//+------------------------------------------------------------------+
MINUTELY CTimeVariables::Minutely(uint Minute)
  {
   return (Minute>59)?MINUTELY(0):MINUTELY(Minute);
  }

//+------------------------------------------------------------------+
//|Convert Integer to the Enumeration SECONDLY                       |
//+------------------------------------------------------------------+
SECONDLY CTimeVariables::Secondly(uint Second)
  {
   return (Second>59)?SECONDLY(0):SECONDLY(Second);
  }
//+------------------------------------------------------------------+
