//+------------------------------------------------------------------+
//|                                                      NewsTrading |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                            https://www.mql5.com/en/users/kaaiblo |
//+------------------------------------------------------------------+
#include "SymbolProperties.mqh"
#include <Charts/Chart.mqh>
CSymbolProperties CSymbol;//Symbol Properties object
//+------------------------------------------------------------------+
//|ChartProperties class                                             |
//+------------------------------------------------------------------+
class CChartProperties : public CChart
  {
private:
//Structure for chart properties
   struct ChartProp
     {
      ENUM_CHART_MODE mode;//Chart Mode
      color          clrBackground;//Chart Background Color
      color          clrForeground;//Chart Foreground Color
      color          clrLineLast;//Chart Line Color
      color          clrCandleBear;//Chart Bear Candle Color
      color          clrBarDown;//Chart Down Candle Color
      color          clrCandleBull;//Chart Bull Candle Color
      color          clrBarUp;//Chart Up Candle Color
      color          clrLineAsk;//Chart Ask Color
      color          clrLineBid;//Chart Bid Color
      color          clrChartLine;//Chart Line Color
      color          clrStopLevels;//Chart Stop Level Color
      color          clrVolumes;//Chart Volumes Color
      bool           Foreground;//Chart Foreground Visibility
      bool           ShowLineAsk;//Chart Ask Line Visibility
      bool           ShowLineBid;//Chart Bid Line Visibility
      bool           ShowPeriodSep;//Chart Period Separator Visibility
      bool           ShowOHLC;//Chart Open-High-Low-Close Visibility
      bool           ShowGrid;//Chart Grid Visibility
      ENUM_CHART_VOLUME_MODE ShowVolumes;//Chart Volumes Visibility
      bool           AutoScroll;//Chart Auto Scroll Option
      bool           Shift;//Chart Shift Option
      double         ShiftSize;//Chart Shift Size
      bool           ShowObjectDescr;//Chart Object Descriptions
      ulong          CHART_SHOW_TRADE_LEVELS;//Chart Trade Levels Visibility
      ulong          CHART_SHOW_ONE_CLICK;//Chart One Click Trading Visibility
      ulong          CHART_SHOW_TICKER;//Chart Ticker Visibility
      ulong          CHART_DRAG_TRADE_LEVELS;//Chart Drag Trade levels
      ENUM_CHART_POSITION Navigate;//Chart Navigate
     };
   ChartProp         DefaultChart,MyChart;//Used to store chart properties
   void              ChartSet(ChartProp &Prop);//Apply Chart format
   void              ChartGet();//Assign Chart property values
public:
                     CChartProperties();//Constructor
                    ~CChartProperties(void);//Destructor
                     //Configure the chart
   void              ChartRefresh() {ChartGet();ChartSet(MyChart);}
   string            GetChartPeriodName();//Retrieve Period name
  };

//+------------------------------------------------------------------+
//|Constructor                                                       |
//+------------------------------------------------------------------+
CChartProperties::CChartProperties()
  {
   m_chart_id=ChartID();//Set chart id
   ChartGet();//Get chart values
   ChartSet(MyChart);//customize chart
  }

//+------------------------------------------------------------------+
//|Destructor                                                        |
//+------------------------------------------------------------------+
CChartProperties::~CChartProperties()
  {
   ChartSet(DefaultChart);//restore chart default configuration
   m_chart_id=-1;//reset chart id
  }

//+------------------------------------------------------------------+
//|Assign Chart property values                                      |
//+------------------------------------------------------------------+
void CChartProperties::ChartGet()
  {
   DefaultChart.mode = Mode();//assign chart mode
   MyChart.mode = CHART_CANDLES;//assign custom chart mode
   DefaultChart.clrBackground = ColorBackground();//assign Background color
   MyChart.clrBackground = (isLightMode)?clrWhite:clrBlack;//assign custom Background color
   DefaultChart.clrForeground = ColorForeground();//assign foreground color
   MyChart.clrForeground = (isLightMode)?clrBlack:clrWhite;//assign custom foreground color
   DefaultChart.clrLineLast = ColorLineLast();//assign Chart Line Color
   MyChart.clrLineLast = clrWhite;//assign custom Chart Line Color
   DefaultChart.clrCandleBear = ColorCandleBear();//assign Chart Bear Candle Color
   MyChart.clrCandleBear = clrBlack;//assign custom Chart Bear Candle Color
   DefaultChart.clrBarDown = ColorBarDown();//assign Chart Down Candle Color
   MyChart.clrBarDown = (isLightMode)?clrBlack:CSymbol.Background();//assign custom Chart Down Candle Color
   DefaultChart.clrCandleBull = ColorCandleBull();//assign Chart Bull Candle Color
   MyChart.clrCandleBull = CSymbol.Background();//assign custom Chart Bull Candle Color
   DefaultChart.clrBarUp = ColorBarUp();//assign Chart Up Candle Color
   MyChart.clrBarUp = (isLightMode)?clrBlack:CSymbol.Background();//assign custom Chart Up Candle Color
   DefaultChart.clrLineAsk = ColorLineAsk();//assign Chart Ask Color 
   MyChart.clrLineAsk = (isLightMode)?clrBlack:clrWhite;//assign custom Chart Ask Color
   DefaultChart.clrLineBid = ColorLineBid();//assign Chart Bid Color
   MyChart.clrLineBid = (isLightMode)?clrBlack:CSymbol.Background();//assign custom Chart Bid Color
   DefaultChart.clrChartLine = ColorChartLine();//assign Chart Line Color
   MyChart.clrChartLine = (isLightMode)?clrBlack:clrWhite;//assign custom Chart Line Color
   DefaultChart.clrStopLevels = ColorStopLevels();//assign Chart Stop Level Color
   MyChart.clrStopLevels = clrRed;//assign custom Chart Stop Level Color
   DefaultChart.clrVolumes = ColorVolumes();//assign Chart Volumes Color
   MyChart.clrVolumes = clrGreen;//assign custom Chart Volumes Color
   DefaultChart.Foreground = Foreground();//assign Chart Foreground Visibility
   MyChart.Foreground = false;//assign custom Chart Foreground Visibility
   DefaultChart.ShowLineAsk = ShowLineAsk();//assign Chart Ask Line Visibility
   MyChart.ShowLineAsk = true;//assign custom Chart Ask Line Visibility
   DefaultChart.ShowLineBid = ShowLineBid();//assign Chart Bid Line Visibility
   MyChart.ShowLineBid = true;//assign custom Chart Bid Line Visibility
   DefaultChart.ShowPeriodSep = ShowPeriodSep();//assign Chart Period Separator Visibility
   MyChart.ShowPeriodSep = true;//assign custom Chart Period Separator Visibility
   DefaultChart.ShowOHLC = ShowOHLC();//assign Chart Open-High-Low-Close Visibility
   MyChart.ShowOHLC = false;//assign custom Chart Open-High-Low-Close Visibility
   DefaultChart.ShowGrid = ShowGrid();//assign Chart Grid Visibility
   MyChart.ShowGrid = false;//assign custom Chart Grid Visibility
   DefaultChart.ShowVolumes = ShowVolumes();//assign Chart Volumes Visibility
   MyChart.ShowVolumes = CHART_VOLUME_HIDE;//assign custom Chart Volumes Visibility
   DefaultChart.AutoScroll = AutoScroll();//assign Chart Auto Scroll Option
   MyChart.AutoScroll = true;//assign custom Chart Auto Scroll Option
   DefaultChart.Shift = Shift();//assign Chart Shift Option
   MyChart.Shift = true;//assign custom Chart Shift Option
   DefaultChart.ShiftSize = ShiftSize();//assign Chart Shift Size
   MyChart.ShiftSize = 15;//assign custom Chart Shift Size
   DefaultChart.ShowObjectDescr = ShowObjectDescr();//assign Chart Object Descriptions
   MyChart.ShowObjectDescr = false;//assign custom Chart Object Descriptions
   DefaultChart.Navigate = CHART_END;//assign Chart Navigate
   MyChart.Navigate = CHART_END;//assign custom Chart Navigate
   //---assign Chart Trade Levels Visibility
   DefaultChart.CHART_SHOW_TRADE_LEVELS = ChartGetInteger(ChartId(),CHART_SHOW_TRADE_LEVELS);
   //---assign custom Chart Trade Levels Visibility
   MyChart.CHART_SHOW_TRADE_LEVELS = ulong(true);
   //---assign Chart One Click Trading Visibility
   DefaultChart.CHART_SHOW_ONE_CLICK = ChartGetInteger(ChartId(),CHART_SHOW_ONE_CLICK);
   //---assign custom Chart One Click Trading Visibility
   MyChart.CHART_SHOW_ONE_CLICK = ulong(false);
   //---assign Chart Ticker Visibility
   DefaultChart.CHART_SHOW_TICKER = ChartGetInteger(ChartId(),CHART_SHOW_TICKER);
   //---assign custom Chart Ticker Visibility
   MyChart.CHART_SHOW_TICKER = ulong(false);
   //---assign Chart Drag Trade levels
   DefaultChart.CHART_DRAG_TRADE_LEVELS = ChartGetInteger(ChartId(),CHART_DRAG_TRADE_LEVELS);
   //---assign custom Chart Drag Trade levels
   MyChart.CHART_DRAG_TRADE_LEVELS = ulong(false);
  }

//+------------------------------------------------------------------+
//|Apply Chart format                                                |
//+------------------------------------------------------------------+
void CChartProperties::ChartSet(ChartProp &Prop)
  {
   Mode(Prop.mode);//Set Chart Candle Mode
   ColorBackground(Prop.clrBackground);//Set Chart Background Color
   ColorForeground(Prop.clrForeground);//Set Chart Foreground Color
   ColorLineLast(Prop.clrLineLast);//Set Chart Line Color
   ColorCandleBear(Prop.clrCandleBear);//Set Chart Bear Candle Color
   ColorBarDown(Prop.clrBarDown);//Set Chart Down Candle Color
   ColorCandleBull(Prop.clrCandleBull);//Set Chart Bull Candle Color
   ColorBarUp(Prop.clrBarUp);//Set Chart Up Candle Color
   ColorLineAsk(Prop.clrLineAsk);//Set Chart Ask Color
   ColorLineBid(Prop.clrLineBid);//Set Chart Bid Color
   ColorChartLine(Prop.clrChartLine);//Set Chart Line Color
   ColorStopLevels(Prop.clrStopLevels);//Set Chart Stop Level Color
   ColorVolumes(Prop.clrVolumes);//Set Chart Volumes Color
   Foreground(Prop.Foreground);//Set if Chart is in Foreground Visibility
   ShowLineAsk(Prop.ShowLineAsk);//Set Chart Ask Line Visibility
   ShowLineBid(Prop.ShowLineBid);//Set Chart Bid Line Visibility
   ShowPeriodSep(Prop.ShowPeriodSep);//Set Chart Period Separator Visibility
   ShowOHLC(Prop.ShowOHLC);//Set Chart Open-High-Low-Close Visibility
   ShowGrid(Prop.ShowGrid);//Set Chart Grid Visibility
   ShowVolumes(Prop.ShowVolumes);//Set Chart Volumes Visibility
   AutoScroll(Prop.AutoScroll);//Set Chart Auto Scroll Option
   Shift(Prop.Shift);//Set Chart Shift Option
   ShiftSize(Prop.ShiftSize);//Set Chart Shift Size Value
   ShowObjectDescr(Prop.ShowObjectDescr);//Set Chart Show Object Descriptions
   ChartSetInteger(ChartId(),CHART_SHOW_TRADE_LEVELS,Prop.CHART_SHOW_TRADE_LEVELS);//Set Chart Trade Levels Visibility
   ChartSetInteger(ChartId(),CHART_SHOW_ONE_CLICK,Prop.CHART_SHOW_ONE_CLICK);//Set Chart One Click Trading Visibility
   ChartSetInteger(ChartId(),CHART_SHOW_TICKER,Prop.CHART_SHOW_TICKER);//Set Chart Ticker Visibility
   ChartSetInteger(ChartId(),CHART_DRAG_TRADE_LEVELS,Prop.CHART_DRAG_TRADE_LEVELS);//Set Chart Drag Trade levels
   Navigate(Prop.Navigate);//Set Chart Navigate
  }

//+------------------------------------------------------------------+
//|Retrieve Period name                                              |
//+------------------------------------------------------------------+
string CChartProperties::GetChartPeriodName()
  {
   switch(ChartPeriod(ChartId()))//Get chart Period with chart id
     {
      case PERIOD_M1:
         return("M1");
      case PERIOD_M2:
         return("M2");
      case PERIOD_M3:
         return("M3");
      case PERIOD_M4:
         return("M4");
      case PERIOD_M5:
         return("M5");
      case PERIOD_M6:
         return("M6");
      case PERIOD_M10:
         return("M10");
      case PERIOD_M12:
         return("M12");
      case PERIOD_M15:
         return("M15");
      case PERIOD_M20:
         return("M20");
      case PERIOD_M30:
         return("M30");
      case PERIOD_H1:
         return("H1");
      case PERIOD_H2:
         return("H2");
      case PERIOD_H3:
         return("H3");
      case PERIOD_H4:
         return("H4");
      case PERIOD_H6:
         return("H6");
      case PERIOD_H8:
         return("H8");
      case PERIOD_H12:
         return("H12");
      case PERIOD_D1:
         return("Daily");
      case PERIOD_W1:
         return("Weekly");
      case PERIOD_MN1:
         return("Monthly");
     }
   return("unknown period");
  }
//+------------------------------------------------------------------+
