//+------------------------------------------------------------------+
//|                                                      NewsTrading |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                            https://www.mql5.com/en/users/kaaiblo |
//+------------------------------------------------------------------+
#include <Trade/AccountInfo.mqh>
//+------------------------------------------------------------------+
//|Account Properties class                                          |
//+------------------------------------------------------------------+
class CAccountProperties: public CAccountInfo
  {
private:
public:
   //--- class constructor
                     CAccountProperties(void) {}
   //--- function to retrieve number of orders in the account
   int               numOrders();
   //--- class destructor
                    ~CAccountProperties(void) {}
  };

//+------------------------------------------------------------------+
//|Retrieve number of orders present in the account                  |
//+------------------------------------------------------------------+
int CAccountProperties::numOrders(void)
  {
   int num=0;
//--- Iterate through all open positions
   for(int i=0; i<OrdersTotal(); i++)
     {
      //--- Check if Position ticket is above zero
      if(OrderGetTicket(i)>0)
        {
         //--- Check for specific Order type values
         switch(int(OrderGetInteger(ORDER_TYPE)))
           {
            case  ORDER_TYPE_BUY_LIMIT:
               num++;
               break;
            case ORDER_TYPE_BUY_STOP:
               num++;
               break;
            case ORDER_TYPE_BUY_STOP_LIMIT:
               num++;
               break;
            case ORDER_TYPE_SELL_LIMIT:
               num++;
               break;
            case ORDER_TYPE_SELL_STOP:
               num++;
               break;
            case ORDER_TYPE_SELL_STOP_LIMIT:
               num++;
               break;
            default:
               break;
           }
        }
     }
//--- return total
   return num;
  }
//+------------------------------------------------------------------+
