//+------------------------------------------------------------------+
//|                                                   TimeByHour.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include <Object.mqh>
#include <Arrays\ArrayObj.mqh>
#include "../TimeVariables.mqh"
#include "../CommonVariables.mqh"
#include "../TimeManagement.mqh"
//--- Structure to store time data in Hour and Minute
struct TimeDate
  {
   int               Hour;
   int               Minute;
  } myTimeData[];
//--- Structure array to store event data in parallel with myTimeData array
Calendar myEvents[];
//+------------------------------------------------------------------+
//|TimeByHour class                                                  |
//+------------------------------------------------------------------+
class CTimeByHour:public CObject
  {
private:
   //--- classes' object declarations
   CTimeManagement   CTime;
   CTimeVariables    CTV;

protected:
   //--- class constructor with parameters
                     CTimeByHour(HOURLY myHour,MINUTELY myMinute,Calendar &myEventData):
      //--- Assign integer variables Hour and Minute with time data from myHour and myMinute respectively
                     Hour(int(myHour)),Minute(int(myMinute))
     {
      //--- Assign variable myEData with event info from variable myEventData
      myEData = myEventData;
     }

   virtual void      myTime(Calendar &myNews[]);
   //--- Array object declarations for each hour of the day
   CArrayObj         *myH1,*myH2,*myH3,*myH4,*myH5,*myH6,*myH7,*myH8,*myH9,*myH10,*myH11,*myH12,*myH13,
                     *myH14,*myH15,*myH16,*myH17,*myH18,*myH19,*myH20,*myH21,*myH22,*myH23,*myH24;
   //--- Integer variables to store time data in hour and minute format
   int               Hour;
   int               Minute;
   //--- Calendar structure variable to store event info
   Calendar          myEData;

public:
   //--- class constructor without parameters
                     CTimeByHour(void)
     {
     }
   //--- Array object variable
   CArrayObj         *getmyTime;
   //--- Retrieve array object for an individual hour
   CObject           *getTime(HOURLY myHour)
     {
      switch(myHour)
        {
         case  H1:
            //--- retrieve array obj for 01 Hour
            return myH1;
            break;
         case H2:
            //--- retrieve array obj for 02 Hour
            return myH2;
            break;
         case H3:
            //--- retrieve array obj for 03 Hour
            return myH3;
            break;
         case H4:
            //--- retrieve array obj for 04 Hour
            return myH4;
            break;
         case H5:
            //--- retrieve array obj for 05 Hour
            return myH5;
            break;
         case H6:
            //--- retrieve array obj for 06 Hour
            return myH6;
            break;
         case H7:
            //--- retrieve array obj for 07 Hour
            return myH7;
            break;
         case H8:
            //--- retrieve array obj for 08 Hour
            return myH8;
            break;
         case H9:
            //--- retrieve array obj for 09 Hour
            return myH9;
            break;
         case H10:
            //--- retrieve array obj for 10 Hour
            return myH10;
            break;
         case H11:
            //--- retrieve array obj for 11 Hour
            return myH11;
            break;
         case H12:
            //--- retrieve array obj for 12 Hour
            return myH12;
            break;
         case H13:
            //--- retrieve array obj for 13 Hour
            return myH13;
            break;
         case H14:
            //--- retrieve array obj for 14 Hour
            return myH14;
            break;
         case H15:
            //--- retrieve array obj for 15 Hour
            return myH15;
            break;
         case H16:
            //--- retrieve array obj for 16 Hour
            return myH16;
            break;
         case H17:
            //--- retrieve array obj for 17 Hour
            return myH17;
            break;
         case H18:
            //--- retrieve array obj for 18 Hour
            return myH18;
            break;
         case H19:
            //--- retrieve array obj for 19 Hour
            return myH19;
            break;
         case H20:
            //--- retrieve array obj for 20 Hour
            return myH20;
            break;
         case H21:
            //--- retrieve array obj for 21 Hour
            return myH21;
            break;
         case H22:
            //--- retrieve array obj for 22 Hour
            return myH22;
            break;
         case H23:
            //--- retrieve array obj for 23 Hour
            return myH23;
            break;
         default:
            //--- retrieve array obj for 24|00 Hour
            return myH24;
            break;
        }
     }
   //--- class pointer variable
   CTimeByHour        *myClass;
   //--- class destructor
                    ~CTimeByHour(void)
     {
      //--- delete all pointer variables
      delete getmyTime;
      delete myClass;
      delete myH1;
      delete myH2;
      delete myH3;
      delete myH4;
      delete myH5;
      delete myH6;
      delete myH7;
      delete myH8;
      delete myH9;
      delete myH10;
      delete myH11;
      delete myH12;
      delete myH13;
      delete myH14;
      delete myH15;
      delete myH16;
      delete myH17;
      delete myH18;
      delete myH19;
      delete myH20;
      delete myH21;
      delete myH22;
      delete myH23;
      delete myH24;
     }
   //--- Function to retrieve timedata and calendar info for a specific hour of the day via parameters passed by reference
   void              GetDataForHour(HOURLY myHour,TimeDate &TimeData[],Calendar &Events[])
     {
      //--- Clean arrays
      ArrayRemove(TimeData,0,WHOLE_ARRAY);
      ArrayRemove(Events,0,WHOLE_ARRAY);
      //--- retrieve array object for the specific hour
      getmyTime = getTime(myHour);
      // Iterate through all the items in the list.
      for(int i=0; i<getmyTime.Total(); i++)
        {
         // Access class obj via array obj index
         myClass = getmyTime.At(i);
         //Re-adjust arrays' sizes
         ArrayResize(TimeData,i+1,i+2);
         ArrayResize(Events,i+1,i+2);
         //--- Assign values to arrays' index
         TimeData[i].Hour = myClass.Hour;
         TimeData[i].Minute = myClass.Minute;
         Events[i] = myClass.myEData;
        }
     }
  };
//+------------------------------------------------------------------+
