//+------------------------------------------------------------------+
//|                                                    TimeByDay.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include "TimeByHour.mqh"
#include "../CommonVariables.mqh"
//+------------------------------------------------------------------+
//|TimeByDay class                                                   |
//+------------------------------------------------------------------+
class CTimeByDay:private CTimeByHour
  {
private:
   //--- Function to clear all array objects
   void              Clear();
   //--- Function to clean array dates in accordance to the current minute
   void              DatePerMinute(TimeDate &TData[],Calendar &EData[],MINUTELY min,TimeDate &TimeData[],Calendar &EventData[])
     {
      //--- Iterate through all the idexes in TData array
      for(uint i=0;i<TData.Size();i++)
        {
         //--- Check if Minutes match
         if(TData[i].Minute==int(min))
           {
            //--- Resize arrays
            ArrayResize(TimeData,TimeData.Size()+1,TimeData.Size()+2);
            ArrayResize(EventData,EventData.Size()+1,EventData.Size()+2);
            //--- Assign data from each array to the other
            TimeData[TimeData.Size()-1] = TData[i];
            EventData[EventData.Size()-1] = EData[i];
           }
        }
     }
public:
   //--- Function to set time for array objects based on calendar array myNews
   void              SetmyTime(Calendar &myNews[])
     {
      //--- Clear previous data stored in array objects
      Clear();
      //--- clean arrays in parallel declared in TimeByHour header file
      ArrayRemove(myTimeData,0,WHOLE_ARRAY);
      ArrayRemove(myEvents,0,WHOLE_ARRAY);
      //--- Set new values to each array object accordingly
      myTime(myNews);
     }
   //--- Function to get time for the specific hour and minute for news events
   void              GetmyTime(HOURLY myHour,MINUTELY myMinute,TimeDate &TimeData[],Calendar &Events[])
     {
      //--- clean arrays in parallel declared in TimeByHour header file
      ArrayRemove(myTimeData,0,WHOLE_ARRAY);
      ArrayRemove(myEvents,0,WHOLE_ARRAY);
      //--- Declare temporary arrays to get news data for a specific hour
      TimeDate myTData[];
      Calendar myData[];
      //--- Get Data for the specific hour of the day
      GetDataForHour(myHour,myTData,myData);
      //--- Filter the Data for a specific Minute of the hour
      DatePerMinute(myTData,myData,myMinute,TimeData,Events);
      //--- Clear data from the temporary array variables
      ArrayRemove(myTData,0,WHOLE_ARRAY);
      ArrayRemove(myData,0,WHOLE_ARRAY);
     }
public:
   //--- Class constructor
                     CTimeByDay(void)
     {
      //--- Initialize array objects
      myH1 = new CArrayObj();
      myH2 = new CArrayObj();
      myH3 = new CArrayObj();
      myH4 = new CArrayObj();
      myH5 = new CArrayObj();
      myH6 = new CArrayObj();
      myH7 = new CArrayObj();
      myH8 = new CArrayObj();
      myH9 = new CArrayObj();
      myH10 = new CArrayObj();
      myH11 = new CArrayObj();
      myH12 = new CArrayObj();
      myH13 = new CArrayObj();
      myH14 = new CArrayObj();
      myH15 = new CArrayObj();
      myH16 = new CArrayObj();
      myH17 = new CArrayObj();
      myH18 = new CArrayObj();
      myH19 = new CArrayObj();
      myH20 = new CArrayObj();
      myH21 = new CArrayObj();
      myH22 = new CArrayObj();
      myH23 = new CArrayObj();
      myH24 = new CArrayObj();
     }
   //--- Class destructor
                    ~CTimeByDay(void)
     {
     }
  };

//+------------------------------------------------------------------+
//|Add data to Array Objects for each Hour of the day                |
//+------------------------------------------------------------------+
void              CTimeByHour::myTime(Calendar &myNews[])
  {
//--- Iterate through myNews calendar array
   for(uint i=0;i<myNews.Size();i++)
     {
      //--- Assign datetime from myNews calendar array
      datetime Date = datetime(myNews[i].EventDate);
      //--- Assign HOURLY Enumeration value from datetime variable Date
      HOURLY myHour = CTV.Hourly(CTime.ReturnHour(Date));
      //--- Assign MINUTELY Enumeration value from datetime variable Date
      MINUTELY myMinute = CTV.Minutely(CTime.ReturnMinute(Date));
      //--- Switch statement to identify each value scenario for myHour
      switch(myHour)
        {
         case  H1:
            //--- add array obj values for 01 Hour
            myH1.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H2:
            //--- add array obj values for 02 Hour
            myH2.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H3:
            //--- add array obj values for 03 Hour
            myH3.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H4:
            //--- add array obj values for 04 Hour
            myH4.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H5:
            //--- add array obj values for 05 Hour
            myH5.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H6:
            //--- add array obj values for 06 Hour
            myH6.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H7:
            //--- add array obj values for 07 Hour
            myH7.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H8:
            //--- add array obj values for 08 Hour
            myH8.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H9:
            //--- add array obj values for 09 Hour
            myH9.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H10:
            //--- add array obj values for 10 Hour
            myH10.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H11:
            //--- add array obj values for 11 Hour
            myH11.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H12:
            //--- add array obj values for 12 Hour
            myH12.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H13:
            //--- add array obj values for 13 Hour
            myH13.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H14:
            //--- add array obj values for 14 Hour
            myH14.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H15:
            //--- add array obj values for 15 Hour
            myH15.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H16:
            //--- add array obj values for 16 Hour
            myH16.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H17:
            //--- add array obj values for 17 Hour
            myH17.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H18:
            //--- add array obj values for 18 Hour
            myH18.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H19:
            //--- add array obj values for 19 Hour
            myH19.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H20:
            //--- add array obj values for 20 Hour
            myH20.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H21:
            //--- add array obj values for 21 Hour
            myH21.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H22:
            //--- add array obj values for 22 Hour
            myH22.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         case H23:
            //--- add array obj values for 23 Hour
            myH23.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
         default:
            //--- add array obj values for 24|00 Hour
            myH24.Add(new CTimeByHour(myHour,myMinute,myNews[i]));
            break;
        }
     }
  }

//+------------------------------------------------------------------+
//|Clear Data in Array Objects                                       |
//+------------------------------------------------------------------+
void CTimeByDay::Clear(void)
  {
//--- Empty all array objects
   myH1.Clear();
   myH2.Clear();
   myH3.Clear();
   myH4.Clear();
   myH5.Clear();
   myH6.Clear();
   myH7.Clear();
   myH8.Clear();
   myH9.Clear();
   myH10.Clear();
   myH11.Clear();
   myH12.Clear();
   myH13.Clear();
   myH14.Clear();
   myH15.Clear();
   myH16.Clear();
   myH17.Clear();
   myH18.Clear();
   myH19.Clear();
   myH20.Clear();
   myH21.Clear();
   myH22.Clear();
   myH23.Clear();
   myH24.Clear();
  }
//+------------------------------------------------------------------+
