//+------------------------------------------------------------------+
//|                                             Fund Manager EA.mq5 |
//|                                Copyright 2024, Clemence Benjamin |
//|             https://www.mql5.com/en/users/billionaire2024/seller |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, Clemence Benjamin"
#property link      "https://www.mql5.com/en/users/billionaire2024/seller"
#property version   "1.01"
#property description "Deposit and Withdraw funds between broker and trading account within the EA"

#import "shell32.dll"
int ShellExecuteW(int hwnd, string lpOperation, string lpFile, string lpParameters, string lpDirectory, int nShowCmd);
#import

//+------------------------------------------------------------------+
//| Input parameters for customization                               |
//+------------------------------------------------------------------+
input double balance_threshold = 100000.0;  // Threshold balance for top-up
input double top_up_amount = 100000.0;      // Amount to top-up if balance is below threshold
input string from_binary = "CR4000128";     // Binary account ID to withdraw funds from. Replace these 
input string to_mt5 = "MTR130002534";     // MT5 account ID to deposit funds into. Replace these are fake for demo.
input string python_script_path = "C:\\Users\\YourComputerName\\PathTo\\deriv_api_handler.py"; // Python script path Replace with actual path at your end.
input string python_exe = "python";         // Python executable command (ensure Python is in PATH)

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   // Step 1: Check account balance
   double current_balance = AccountInfoDouble(ACCOUNT_BALANCE);
   Print("Current Account Balance: ", current_balance);

   // Step 2: If balance is less than the threshold, perform a deposit attempt
   if(current_balance < balance_threshold)
     {
      Print("Balance is below the threshold. Attempting a deposit...");

      // Write the deposit command to the file
      string command_file = "mql5_to_python.txt";
      string command_path = TerminalInfoString(TERMINAL_COMMONDATA_PATH) + "\\Files\\" + command_file;
      ResetLastError();
      int handle = FileOpen(command_file, FILE_WRITE | FILE_COMMON | FILE_TXT | FILE_ANSI);

      if(handle < 0)
        {
         Print("Error opening file for writing: ", GetLastError());
         return(INIT_FAILED);
        }

      // Deposit command in JSON format
      string deposit_command = StringFormat("{\"mt5_deposit\": 1, \"amount\": %.2f, \"from_binary\": \"%s\", \"req_id\": 1, \"to_mt5\": \"%s\"}", top_up_amount, from_binary, to_mt5);
      FileWrite(handle, deposit_command);
      FileClose(handle);
      Print("Deposit command written to file: ", command_path);

      // Step 3: Launch the Python script
      int result = ShellExecuteW(0, "open", python_exe, python_script_path, NULL, 1);
      if(result <= 32)
        {
         Print("Failed to launch Python script. Error code: ", result);
         return(INIT_FAILED);
        }
      else
        {
         Print("Python script launched successfully.");
        }

      // Step 4: Wait for the Python script to process the command
      Sleep(5000); // Wait for 5 seconds

      // Step 5: Check the response file for confirmation
      string response_file = "python_to_mql5.txt";
      string response_path = TerminalInfoString(TERMINAL_COMMONDATA_PATH) + "\\Files\\" + response_file;

      if(FileIsExist(response_file, FILE_COMMON))
        {
         handle = FileOpen(response_file, FILE_READ | FILE_COMMON | FILE_TXT | FILE_ANSI);
         if(handle < 0)
           {
            Print("Error opening response file: ", GetLastError());
            return(INIT_FAILED);
           }

         string response = FileReadString(handle);
         FileClose(handle);
         Print("Response file path: ", response_path);
         Print("Response from Python: ", response);

         // Optional: Parse response to check for success or failure
         if(StringFind(response, "\"status\":\"success\"") >= 0)
           {
            Print("Deposit was successful.");
           }
         else
           {
            Print("Deposit failed. Response: ", response);
           }
        }
      else
        {
         Print("Response file not found at: ", response_path, ". Ensure the Python script is running and processing the command.");
        }
     }
   else
     {
      Print("Balance is above the threshold. No deposit attempt needed.");
     }

   // Initialization completed
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   Print("Expert deinitialized.");
  }



