//+------------------------------------------------------------------+
//|                                               SignalCGAN.mqh |
//|                   Copyright 2009-2017, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#include <My\Cgan.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on Conditional GAN                           |
//| Type=SignalAdvanced                                              |
//| Name=CGAN                                                        |
//| ShortName=CGAN                                                   |
//| Class=CSignalCGAN                                                |
//| Page=signal_cgan                                                 |
//| Parameter=TrainSet,int,30,Training Set Size                      |
//| Parameter=Epochs,int,6,Epochs                                    |
//| Parameter=LearningRate,double,0.005,LearningRate                 |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalCGAN.                                               |
//| Purpose: Class of Conditional GAN.                               |
//|            Derives from class CExpertSignal.                     |
//+------------------------------------------------------------------+
#define  __LAYERS 5
#define  __SIZES 5
#define  __GEN_INPUTS 4
#define  __GEN_OUTPUTS 1
int      __GEN_SETTINGS[2 + __LAYERS] //generator network settings

=
{  __GEN_INPUTS,  __SIZES, __SIZES,  __SIZES,  __SIZES,  __SIZES,  __GEN_OUTPUTS
};
#define  __DIS_OUTPUTS 1
int      __DIS_SETTINGS[2 + __LAYERS] //discriminator settings

=
{  __GEN_INPUTS + __GEN_OUTPUTS,  __SIZES, __SIZES,  __SIZES,  __SIZES,  __SIZES,  __DIS_OUTPUTS
};

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CSignalCGAN   : public CExpertSignal
{
protected:

   int                           m_train_set;                       //
   int                           m_epochs;                              // Epochs
   double                        m_learning_rate;                       // Epsilon

   double                        m_train_deposit;
   double                        m_train_criteria;

public:
                     CSignalCGAN(void);
                    ~CSignalCGAN(void);

   //--- methods of setting adjustable parameters
   void                          TrainSet(int value)
   {  m_train_set = value;
   }
   void                          Epochs(int value)
   {  m_epochs = value;
   }
   void                          LearningRate(double value)
   {  m_learning_rate = value;
   }

   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void);
   virtual int       ShortCondition(void);

protected:
   void                          GetOutput(double &GenOut, bool &DisOut);
   void                          SetOutput();
   
   void                          F(vector &IN, vector &OUT);
   void                          R(vector &IN, vector &OUT);

   Cgan                          *GEN;
   Cgan                          *DIS;
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CSignalCGAN::CSignalCGAN(void) :    m_train_set(390),
   m_epochs(30),
   m_learning_rate(0.005)

{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_SPREAD + USE_SERIES_TIME;
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CSignalCGAN::~CSignalCGAN(void)
{  delete GEN;
   delete DIS;
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalCGAN::ValidationSettings(void)
{  if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   if(m_epochs < 1)
   {  printf(__FUNCSIG__ + " epochs size should at least be 1! ");
      return(false);
   }
   if(m_learning_rate < 0.0)
   {  printf(__FUNCSIG__ + " learning rate should be greater than 0.0! ");
      return(false);
   }
   GEN = new Cgan(__GEN_SETTINGS, 0.1, 0.01);
   DIS = new Cgan(__DIS_SETTINGS, 0.1, 0.01);
   m_train_deposit = AccountInfoDouble(ACCOUNT_BALANCE);
   m_train_criteria = 0.0;
//read best weights
//datetime _version;
//N.Get(m_symbol.Name()+"_"+EnumToString(m_period), m_train_criteria, _version);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalCGAN::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalCGAN::LongCondition(void)
{  int result = 0;
   double _gen_out = 0.0;
   bool _dis_out = false;
   GetOutput(_gen_out, _dis_out);
   _gen_out *= 100.0;
   if(_dis_out && _gen_out > 50.0)
   {  result = int(_gen_out);
   }
   //printf(__FUNCSIG__ + " generator output is: %.5f, which is backed by discriminator as: %s", _gen_out, string(_dis_out));
   return(result);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalCGAN::ShortCondition(void)
{  int result = 0;
   double _gen_out = 0.0;
   bool _dis_out = false;
   GetOutput(_gen_out, _dis_out);
   _gen_out *= 100.0;
   if(_dis_out && _gen_out < 50.0)
   {  result = int(fabs(_gen_out));
   }
   return(result);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CSignalCGAN::GetOutput(double &GenOut, bool &DisOut)
{  GenOut = 0.0;
   DisOut = false;
   for(int i = m_epochs; i >= 0; i--)
   {  for(int ii = m_train_set; ii >= 0; ii--)
      {  vector _in, _out;
         vector _in_new, _out_new, _in_old, _out_old;
         _in_new.CopyRates(m_symbol.Name(), m_period, 8, ii + 1, __GEN_INPUTS);
         _in_old.CopyRates(m_symbol.Name(), m_period, 8, ii + 1 + 1, __GEN_INPUTS);
         _in = Norm(_in_new, _in_old);
         GEN.Set(_in);
         GEN.Forward();
         if(ii > 0)// train
         {  _out_new.CopyRates(m_symbol.Name(), m_period, 8, ii, __GEN_OUTPUTS);
            _out_old.CopyRates(m_symbol.Name(), m_period, 8, ii + 1, __GEN_OUTPUTS);
            _out = Norm(_out_new, _out_old);
            //
            int _dis_sort = MathRand()%2;
            if(_dis_sort == 0)
            {  F(_in, GEN.output);
               GEN.Get(_out);
               GEN.Backward(DIS.output, m_learning_rate);
               R(_in, _out);
            }
            else if(_dis_sort == 1)
            {  R(_in, _out);
               GEN.Get(_out);
               GEN.Backward(DIS.output, m_learning_rate);
               F(_in, GEN.output);
            }
         }
         else if(ii == 0 && i == 0)
         {  GenOut = GEN.output[0];
            DisOut = (((DIS.output[0] >= 0.5 && GenOut >= 0.5)||(DIS.output[0] < 0.5 && GenOut < 0.5)) ? true : false);
         }
      }
   }
}
//+------------------------------------------------------------------+
//| Process Fake Data in Discriminator                               |
//+------------------------------------------------------------------+
void CSignalCGAN::F(vector &IN, vector &OUT)
{  vector _out_f, _out_fake, _in_fake;
   _out_f.Copy(OUT);
   _in_fake.Copy(IN);
   Sum(_in_fake, _out_f);
   DIS.Set(_in_fake);
   DIS.Forward();
   _out_fake.Resize(__DIS_OUTPUTS);
   _out_fake.Fill(0.0);
   DIS.Get(_out_fake);
   DIS.Backward(m_learning_rate);
}
//+------------------------------------------------------------------+
//| Process Real Data in Discriminator                               |
//+------------------------------------------------------------------+
void CSignalCGAN::R(vector &IN, vector &OUT)
{  vector _out_r, _out_real, _in_real;
   _out_r.Copy(OUT);
   _in_real.Copy(IN);
   Sum(_in_real, _out_r);
   DIS.Set(_in_real);
   DIS.Forward();
   _out_real.Resize(__DIS_OUTPUTS);
   _out_real.Fill(1.0);
   DIS.Get(_out_real);
   DIS.Backward(m_learning_rate);
}
//+------------------------------------------------------------------+
//| Weights & Biases exporting function for network                  |
//+------------------------------------------------------------------+
void CSignalCGAN::SetOutput(void)
{  if(AccountInfoDouble(ACCOUNT_EQUITY) - m_train_deposit > m_train_criteria && m_train_criteria >= 0.0)
   {  GEN.Set(m_symbol.Name() + "_" + EnumToString(m_period), AccountInfoDouble(ACCOUNT_EQUITY) - m_train_deposit);
      DIS.Set(m_symbol.Name() + "_" + EnumToString(m_period), AccountInfoDouble(ACCOUNT_EQUITY) - m_train_deposit);
   }
}
//+------------------------------------------------------------------+
//| Normalization                                                    |
//+------------------------------------------------------------------+
vector Norm(vector &A, vector &B)
{  vector _n;
   _n.Init(A.Size());
   if(A.Size() > 0 && B.Size() > 0 && A.Size() == B.Size() && A.Min() > 0.0 && B.Min() > 0.0)
   {  int _size = int(A.Size());
      _n.Fill(0.5);
      for(int i = 0; i < _size; i++)
      {  if(A[i] > B[i])
         {  _n[i] += (0.5 * ((A[i] - B[i]) / A[i]));
         }
         else if(A[i] < B[i])
         {  _n[i] -= (0.5 * ((B[i] - A[i]) / B[i]));
         }
      }
   }
   return(_n);
}
//+------------------------------------------------------------------+
//| Add Vector B to A                                                |
//+------------------------------------------------------------------+
void Sum(vector &A, vector &B)
{  int _a_size = int(A.Size());
   A.Resize(_a_size + B.Size());
   for(int i = _a_size; i < int(_a_size + B.Size()); i++)
   {  A[i] = B[i - _a_size];
   }
}
//+------------------------------------------------------------------+
