//+------------------------------------------------------------------+
//|                                                     opt_17_1.mq5 |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Include                                                          |
//+------------------------------------------------------------------+
#include <Expert\ExpertFolio_2.mqh>
//--- available signals
#include <Expert\Signal\SignalRSI.mqh>
//--- available trailing
#include <Expert\Trailing\TrailingNone.mqh>
//--- available money management
#include <Expert\Money\MoneyNone.mqh>
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
//--- inputs for expert
input string             Expert_Title         = "opt_17_1"; // Document name
ulong                    Expert_MagicNumber   = 8200;       //
bool                     Expert_EveryTick     = false;      //
//--- inputs for main signals[f]
input int                Signal_ThresholdOpen = 10;         // Signal threshold value to open [0...100]
input int                Signal_ThresholdClose = 10;        // Signal threshold value to close [0...100]
input double             Signal_PriceLevel    = 0.0;        // Price level to execute a deal
input double             Signal_StopLevel     = 50.0;       // Stop Loss level (in points)
input double             Signal_TakeLevel     = 50.0;       // Take Profit level (in points)
input int                Signal_Expiration    = 4;          // Expiration of pending orders (in bars)
input int                Signal_RSI_PeriodRSI = 8;          // Relative Strength Index(8,...) Period of calculation
input ENUM_APPLIED_PRICE Signal_RSI_Applied   = PRICE_CLOSE;// Relative Strength Index(8,...) Prices series
input double             Signal_RSI_Weight    = 1.0;        // Relative Strength Index(8,...) Weight [0...1.0]
//+------------------------------------------------------------------+
//| Global expert object                                             |
//+------------------------------------------------------------------+
CExpert ExtExpert[__FOLIO];
CExpertSignal *signals[__FOLIO];
//+------------------------------------------------------------------+
//| Initialization function of the expert                            |
//+------------------------------------------------------------------+
int OnInit()
{  for(int f = 0; f < __FOLIO; f++)
   {
//--- Initializing expert
      if(!ExtExpert[f].Init( __F[f], Period(), Expert_EveryTick, Expert_MagicNumber))
      {  //--- failed
         printf(__FUNCTION__ + ": error initializing expert");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Creating signals[f]
      signals[f] = new CExpertSignal;
      if(signals[f] == NULL)
      {  //--- failed
         printf(__FUNCTION__ + ": error creating signals[f]");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//---
      ExtExpert[f].InitSignal(signals[f]);
      signals[f].ThresholdOpen(Signal_ThresholdOpen);
      signals[f].ThresholdClose(Signal_ThresholdClose);
      signals[f].PriceLevel(Signal_PriceLevel);
      signals[f].StopLevel(Signal_StopLevel);
      signals[f].TakeLevel(Signal_TakeLevel);
      signals[f].Expiration(Signal_Expiration);
//--- Creating filter CSignalRSI
      CSignalRSI *filter0 = new CSignalRSI;
      if(filter0 == NULL)
      {  //--- failed
         printf(__FUNCTION__ + ": error creating filter0");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
      signals[f].AddFilter(filter0);
//--- Set filter parameters
      filter0.PeriodRSI(Signal_RSI_PeriodRSI);
      filter0.Applied(Signal_RSI_Applied);
      filter0.Weight(Signal_RSI_Weight);
//--- Creation of trailing object
      CTrailingNone *trailing = new CTrailingNone;
      if(trailing == NULL)
      {  //--- failed
         printf(__FUNCTION__ + ": error creating trailing");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Add trailing to expert (will be deleted automatically))
      if(!ExtExpert[f].InitTrailing(trailing))
      {  //--- failed
         printf(__FUNCTION__ + ": error initializing trailing");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Set trailing parameters
//--- Creation of money object
      CMoneyNone *money = new CMoneyNone;
      if(money == NULL)
      {  //--- failed
         printf(__FUNCTION__ + ": error creating money");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Add money to expert (will be deleted automatically))
      if(!ExtExpert[f].InitMoney(money))
      {  //--- failed
         printf(__FUNCTION__ + ": error initializing money");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Set money parameters
//--- Check all trading objects parameters
      if(!ExtExpert[f].ValidationSettings())
      {  //--- failed
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Tuning of all necessary indicators
      if(!ExtExpert[f].InitIndicators())
      {  //--- failed
         printf(__FUNCTION__ + ": error initializing indicators");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
      //
      ExtExpert[f].OnTimerProcess(true);
   }
   EventSetTimer(PeriodSeconds(Period()));
//--- ok
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Deinitialization function of the expert                          |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{  for(int f = 0; f < __FOLIO; f++)
   {  ExtExpert[f].Deinit();
   }
   EventKillTimer();
}
//+------------------------------------------------------------------+
//| "Tick" event handler function                                    |
//+------------------------------------------------------------------+
void OnTick()
{  for(int f = 0; f < __FOLIO; f++)
   {  ExtExpert[f].Magic(f);
      ExtExpert[f].OnTick();
   }
}
//+------------------------------------------------------------------+
//| "Trade" event handler function                                   |
//+------------------------------------------------------------------+
void OnTrade()
{  for(int f = 0; f < __FOLIO; f++)
   {  ExtExpert[f].Magic(f);
      ExtExpert[f].OnTrade();
   }
}
//+------------------------------------------------------------------+
//| "Timer" event handler function                                   |
//+------------------------------------------------------------------+
void OnTimer()
{  for(int f = 0; f < __FOLIO; f++)
   {  ExtExpert[f].Refresh();
   }
   for(int f = 0; f < __FOLIO; f++)
   {  int _index = -1;
      ENUM_POSITION_TYPE _type = INVALID_HANDLE;
      ExtExpert[f].Magic(f);
      if(Select(signals[f].Direction(), _index, _type))
      {  ExtExpert[f].OnTimer();
         ExtExpert[f].Processing();
      }
   }
}
//+------------------------------------------------------------------+
//| Symbol Selector via Correlation                                  |
//+------------------------------------------------------------------+
bool  Select(double Direction, int &Index, ENUM_POSITION_TYPE &Type)
{  if(PositionsTotal() == 0)
   {  double _max = 0.0;
      int _index = -1;
      Type = INVALID_HANDLE;
      for(int f = 0; f < __FOLIO; f++)
      {  vector _v_0, _v_1;
         _v_0.CopyRates(__F[f], Period(), 8, 0, 30);
         _v_1.CopyRates(__F[f], Period(), 8, 30, 30);
         double _corr = _v_0.CorrCoef(_v_1);
         if(_max < _corr && ((Direction > 0.0 && _v_0[0] > _v_0[29]) || (Direction < 0.0 && _v_0[0] < _v_0[29])))
         {  _max = _corr;
            _index = f;
            if(_v_0[0] > _v_0[29])
            {  Type = POSITION_TYPE_BUY;
            }
            else if(_v_0[0] < _v_0[29])
            {  Type = POSITION_TYPE_SELL;
            }
         }
      }
      Index = _index;
      return(true);
   }
   else if(PositionsTotal() == 1)
   {  ulong _ticket = PositionGetTicket(0);
      if(PositionSelectByTicket(_ticket))
      {  double _float = PositionGetDouble(POSITION_PROFIT);
         ENUM_POSITION_TYPE _type = (ENUM_POSITION_TYPE)PositionGetInteger(POSITION_TYPE);
         int _index = ArrayBsearch(__F, PositionGetString(POSITION_SYMBOL));
         double _max = 0.0;
         Type = INVALID_HANDLE;
         for(int f = 0; f < __FOLIO; f++)
         {  if(f == _index)
            {  continue;
            }
            else
            {  vector _v_0, _v_1;
               _v_0.CopyRates(__F[_index], Period(), 8, 0, 30);
               _v_1.CopyRates(__F[f], Period(), 8, 0, 30);
               double _corr = fabs(_v_0.CorrCoef(_v_1));
               if(_float < 0.0 && _max < _corr)
               {  _max = _corr;
                  Index = f;
                  if(_v_1[0] > _v_1[29])
                  {  Type = POSITION_TYPE_BUY;
                  }
                  else  if(_v_1[0] < _v_1[29])
                  {  Type = POSITION_TYPE_SELL;
                  }
               }
            }
         }
      }
      return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Array Boolean Search for String                                  |
//+------------------------------------------------------------------+
int ArrayBsearch(const string &Array[], string String)
{  int _search = -1, _size = ArraySize(Array);
   if(_size <= 0)
   {  return(_search);
   }
   for(int i = 0; i < _size; i++)
   {  if(Array[i] == String)
      {  _search = i;
         break;
      }
   }
   return(_search);
}
//+------------------------------------------------------------------+
