//+------------------------------------------------------------------+
//|                                                     opt_17_1.mq5 |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Include                                                          |
//+------------------------------------------------------------------+
#include <Expert\ExpertFolio_1.mqh>
//--- available signals
#include <Expert\Signal\SignalRSI.mqh>
//--- available trailing
#include <Expert\Trailing\TrailingNone.mqh>
//--- available money management
#include <Expert\Money\MoneyNone.mqh>
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
//--- inputs for expert
input string             Expert_Title         = "opt_17_1"; // Document name
ulong                    Expert_MagicNumber   = 8200;       //
bool                     Expert_EveryTick     = false;      //
//--- inputs for main signals[f]
input int                Signal_ThresholdOpen = 10;         // Signal threshold value to open [0...100]
input int                Signal_ThresholdClose = 10;        // Signal threshold value to close [0...100]
input double             Signal_PriceLevel    = 0.0;        // Price level to execute a deal
input double             Signal_StopLevel     = 50.0;       // Stop Loss level (in points)
input double             Signal_TakeLevel     = 50.0;       // Take Profit level (in points)
input int                Signal_Expiration    = 4;          // Expiration of pending orders (in bars)
input int                Signal_RSI_PeriodRSI = 8;          // Relative Strength Index(8,...) Period of calculation
input ENUM_APPLIED_PRICE Signal_RSI_Applied   = PRICE_CLOSE; // Relative Strength Index(8,...) Prices series
input double             Signal_RSI_Weight    = 1.0;        // Relative Strength Index(8,...) Weight [0...1.0]
//+------------------------------------------------------------------+
//| Global expert object                                             |
//+------------------------------------------------------------------+
CExpert ExtExpert[__FOLIO];
CExpertSignal *signals[__FOLIO];
//+------------------------------------------------------------------+
//| Initialization function of the expert                            |
//+------------------------------------------------------------------+
int OnInit()
{  for(int f = 0; f < __FOLIO; f++)
   {
//--- Initializing expert
      if(!ExtExpert[f].Init(__prefix+__F[f]+__suffix, Period(), Expert_EveryTick, Expert_MagicNumber))
      {  //--- failed
         printf(__FUNCTION__ + ": error initializing expert");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Creating signals[f]
      signals[f] = new CExpertSignal;
      if(signals[f] == NULL)
      {  //--- failed
         printf(__FUNCTION__ + ": error creating signals[f]");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//---
      ExtExpert[f].InitSignal(signals[f]);
      signals[f].ThresholdOpen(Signal_ThresholdOpen);
      signals[f].ThresholdClose(Signal_ThresholdClose);
      signals[f].PriceLevel(Signal_PriceLevel);
      signals[f].StopLevel(Signal_StopLevel);
      signals[f].TakeLevel(Signal_TakeLevel);
      signals[f].Expiration(Signal_Expiration);
//--- Creating filter CSignalRSI
      CSignalRSI *filter0 = new CSignalRSI;
      if(filter0 == NULL)
      {  //--- failed
         printf(__FUNCTION__ + ": error creating filter0");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
      signals[f].AddFilter(filter0);
//--- Set filter parameters
      filter0.PeriodRSI(Signal_RSI_PeriodRSI);
      filter0.Applied(Signal_RSI_Applied);
      filter0.Weight(Signal_RSI_Weight);
//--- Creation of trailing object
      CTrailingNone *trailing = new CTrailingNone;
      if(trailing == NULL)
      {  //--- failed
         printf(__FUNCTION__ + ": error creating trailing");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Add trailing to expert (will be deleted automatically))
      if(!ExtExpert[f].InitTrailing(trailing))
      {  //--- failed
         printf(__FUNCTION__ + ": error initializing trailing");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Set trailing parameters
//--- Creation of money object
      CMoneyNone *money = new CMoneyNone;
      if(money == NULL)
      {  //--- failed
         printf(__FUNCTION__ + ": error creating money");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Add money to expert (will be deleted automatically))
      if(!ExtExpert[f].InitMoney(money))
      {  //--- failed
         printf(__FUNCTION__ + ": error initializing money");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Set money parameters
//--- Check all trading objects parameters
      if(!ExtExpert[f].ValidationSettings())
      {  //--- failed
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
//--- Tuning of all necessary indicators
      if(!ExtExpert[f].InitIndicators())
      {  //--- failed
         printf(__FUNCTION__ + ": error initializing indicators");
         ExtExpert[f].Deinit();
         return(INIT_FAILED);
      }
   }
//--- ok
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Deinitialization function of the expert                          |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{  for(int f = 0; f < __FOLIO; f++)
   {  ExtExpert[f].Deinit();
   }
}
//+------------------------------------------------------------------+
//| "Tick" event handler function                                    |
//+------------------------------------------------------------------+
void OnTick()
{  for(int f = 0; f < __FOLIO; f++)
   {  ExtExpert[f].OnTick();//
   }
}
//+------------------------------------------------------------------+
//| "Trade" event handler function                                   |
//+------------------------------------------------------------------+
void OnTrade()
{  for(int f = 0; f < __FOLIO; f++)
   {  ExtExpert[f].OnTrade();
   }
}
//+------------------------------------------------------------------+
//| "Timer" event handler function                                   |
//+------------------------------------------------------------------+
void OnTimer()
{  for(int f = 0; f < __FOLIO; f++)
   {  ExtExpert[f].OnTimer();
   }
}
//+------------------------------------------------------------------+
