//+------------------------------------------------------------------+
//|                                            NewIndicatorPlan2.mqh |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//----   
extern int period0 = 15;
extern int period1 = 15;
extern int period2 = 15;
//----  
double Ind_Buffer0[];
double Ind_Buffer1[];
double Ind_Buffer2[];
//----     
string symbol;
int timeframe;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----    ר 
   symbol = Symbol(); //   symbol;
   timeframe = 240;   //   timeframe;
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----     
   int IBARS = iBars(symbol, timeframe);
//----        
   if(IBARS < period0 + period1 + period2)
       return(0);
//----   
   if(ArraySize(Ind_Buffer0) < IBARS)
     {
       ArraySetAsSeries(Ind_Buffer0, false);
       ArraySetAsSeries(Ind_Buffer1, false);
       ArraySetAsSeries(Ind_Buffer2, false);
       //----  
       ArrayResize(Ind_Buffer0, IBARS); 
       ArrayResize(Ind_Buffer1, IBARS); 
       ArrayResize(Ind_Buffer2, IBARS); 
       //----
       ArraySetAsSeries(Ind_Buffer0, true);
       ArraySetAsSeries(Ind_Buffer1, true);
       ArraySetAsSeries(Ind_Buffer2, true); 
     } 
//----+     
   static int IndCounted;
//----+     
   double Resalt0, Resalt1, Resalt2;
//----+        
   int limit, MaxBar, bar, counted_bars = IndCounted;
//----+     
   IndCounted = IBARS - 1;
//----     , 
//        
   limit = IBARS - counted_bars - 1; 
//----     , 
//        
   MaxBar = IBARS - 1 - (period0 + period1 + period2); 
//----   
   if(limit > MaxBar)
     {
       limit = MaxBar;
       for(bar = IBARS - 1; bar >= 0; bar--)
         {
           Ind_Buffer0[bar] = 0.0;
           Ind_Buffer1[bar] = 0.0;
           Ind_Buffer2[bar] = 0.0;
         }
     }
//----+     
   for(bar = IBARS - 1; bar >= 0; bar--)
     {
       //     Resalt1  
       //    period1
       Ind_Buffer1[bar] = Resalt1;
     }
//----+     
   for(bar = limit; bar >= 0; bar--)
     {
       //     Resalt2 
       //     Ind_Buffer1[]  
       //   period2
       Ind_Buffer2[bar] = Resalt2;
     }
//----+     
   for(bar = limit; bar >= 0; bar--)
     {
       //     Resalt0 
       //     Ind_Buffer2[]  
       //   period0
       Ind_Buffer0[bar] = Resalt0;
     }
   return(0);
  }
//+------------------------------------------------------------------+