//+------------------------------------------------------------------+
//|                                               IndicatorPlan1.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//----   
extern int period0 = 15;
extern int period1 = 15;
extern int period2 = 15;
//----  
double Ind_Buffer0[];
double Ind_Buffer1[];
double Ind_Buffer2[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----        
   if(Bars < period0 + period1 + period2)
       return(0);
//----+     
   double Resalt0, Resalt1, Resalt2;
//----+        
   int limit, MaxBar, bar, counted_bars = IndicatorCounted();
//----    
   if(counted_bars < 0)
       return(-1);
//----       
   if(counted_bars > 0) 
       counted_bars--;
//----     , 
//        
   limit = Bars - counted_bars - 1; 
//----     , 
//        
   MaxBar = Bars - 1 - (period0 + period1 + period2); 
//----   
   if(limit > MaxBar)
     {
       limit = MaxBar;
       for(bar = Bars - 1; bar >= MaxBar; bar--)
         {
           Ind_Buffer0[bar] = 0.0;
           Ind_Buffer1[bar] = 0.0;
           Ind_Buffer2[bar] = 0.0;
         }
     }
//----+     
   for(bar = limit; bar >= 0; bar--)
     {
       //     Resalt1  
       //    period1
       Ind_Buffer1[bar] = Resalt1;
     }
//----+     
   for(bar = limit; bar >= 0; bar--)
     {
       //     Resalt2 
       //     Ind_Buffer1[]  
       //   period2
       Ind_Buffer2[bar] = Resalt2;
     }
//----+     
   for(bar=limit;bar>=0;bar--)
     {
       //     Resalt0 
       //     Ind_Buffer2[]  
       //   period0
       Ind_Buffer0[bar] = Resalt0;
     }
   return(0);
  }
//+------------------------------------------------------------------+