//+------------------------------------------------------------------+
//|                                                       dbscan.mq5 |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Include                                                          |
//+------------------------------------------------------------------+
#include <Expert\Expert.mqh>
//--- available signals
#include <Expert\Signal\My\SignalWZ_13_b_ma.mqh>
//--- available trailing
#include <Expert\Trailing\TrailingNone.mqh>
//--- available money management
#include <Expert\Money\MoneyFixedMargin.mqh>
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
//--- inputs for expert
input string Expert_Title           = "dbscan"; // Document name
ulong        Expert_MagicNumber     = 22397;   //
bool         Expert_EveryTick       = false;   //
//--- inputs for main signal
input int    Signal_ThresholdOpen   = 10;      // Signal threshold value to open [0...100]
input int    Signal_ThresholdClose  = 10;      // Signal threshold value to close [0...100]
input double Signal_PriceLevel      = 0.0;     // Price level to execute a deal
input double Signal_StopLevel       = 50.0;    // Stop Loss level (in points)
input double Signal_TakeLevel       = 50.0;    // Take Profit level (in points)
input int    Signal_Expiration      = 4;       // Expiration of pending orders (in bars)
input int    Signal_DBSCAN_LagA      = 4;       // RSI Lag A (in bars)
input int    Signal_DBSCAN_LagB      = 4;       // RSI Lag B (in bars)
input int    Signal_DBSCAN_LagC      = 4;       // RSI Lag C (in bars)
input int    Signal_DBSCAN_KeySize  = 3;       // CategoryTheory(4,30,2,12.5) Key Size
input int    Signal_DBSCAN_SetSize  = 30;      // CategoryTheory(4,30,2,12.5) Set Size
input int    Signal_DBSCAN_MinPoints = 2;      // CategoryTheory(4,30,2,12.5) Min Points
input double Signal_DBSCAN_Epsilon  = 12.5;    // CategoryTheory(4,30,2,12.5) Epsilon
input double Signal_DBSCAN_Weight   = 1.0;     // CategoryTheory(4,30,2,12.5) Weight [0...1.0]
//--- inputs for money
input double Money_FixMargin_Percent = 10.0;   // Percentage of margin
//+------------------------------------------------------------------+
//| Global expert object                                             |
//+------------------------------------------------------------------+
CExpert ExtExpert;
//+------------------------------------------------------------------+
//| Initialization function of the expert                            |
//+------------------------------------------------------------------+
int OnInit()
{
//--- Initializing expert
   if(!ExtExpert.Init(Symbol(), Period(), Expert_EveryTick, Expert_MagicNumber))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing expert");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Creating signal
   CExpertSignal *signal = new CExpertSignal;
   if(signal == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating signal");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//---
   ExtExpert.InitSignal(signal);
   signal.ThresholdOpen(Signal_ThresholdOpen);
   signal.ThresholdClose(Signal_ThresholdClose);
   signal.PriceLevel(Signal_PriceLevel);
   signal.StopLevel(Signal_StopLevel);
   signal.TakeLevel(Signal_TakeLevel);
   signal.Expiration(Signal_Expiration);
//--- Creating filter CSignalDBSCAN
   CSignalDBSCAN *filter0 = new CSignalDBSCAN;
   if(filter0 == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating filter0");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
   signal.AddFilter(filter0);
//--- Set filter parameters
   filter0.LagA(Signal_DBSCAN_LagA);
   filter0.LagB(Signal_DBSCAN_LagB);
   filter0.LagC(Signal_DBSCAN_LagC);
   //
   filter0.KeySize(Signal_DBSCAN_KeySize);
   filter0.SetSize(Signal_DBSCAN_SetSize);
   filter0.MinPoints(Signal_DBSCAN_MinPoints);
   filter0.Epsilon(Signal_DBSCAN_Epsilon);
   filter0.Weight(Signal_DBSCAN_Weight);
//--- Creation of trailing object
   CTrailingNone *trailing = new CTrailingNone;
   if(trailing == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating trailing");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Add trailing to expert (will be deleted automatically))
   if(!ExtExpert.InitTrailing(trailing))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing trailing");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Set trailing parameters
//--- Creation of money object
   CMoneyFixedMargin *money = new CMoneyFixedMargin;
   if(money == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating money");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Add money to expert (will be deleted automatically))
   if(!ExtExpert.InitMoney(money))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing money");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Set money parameters
   money.Percent(Money_FixMargin_Percent);
//--- Check all trading objects parameters
   if(!ExtExpert.ValidationSettings())
   {  //--- failed
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Tuning of all necessary indicators
   if(!ExtExpert.InitIndicators())
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing indicators");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- ok
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Deinitialization function of the expert                          |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{  ExtExpert.Deinit();
}
//+------------------------------------------------------------------+
//| "Tick" event handler function                                    |
//+------------------------------------------------------------------+
void OnTick()
{  ExtExpert.OnTick();
}
//+------------------------------------------------------------------+
//| "Trade" event handler function                                   |
//+------------------------------------------------------------------+
void OnTrade()
{  ExtExpert.OnTrade();
}
//+------------------------------------------------------------------+
//| "Timer" event handler function                                   |
//+------------------------------------------------------------------+
void OnTimer()
{  ExtExpert.OnTimer();
}
//+------------------------------------------------------------------+
