# Copyright 2024, MetaQuotes Ltd.
# https://www.mql5.com

import onnx
from onnxconverter_common import float16
from sys import argv

# define the path for saving the model
data_path = argv[0]
last_index = data_path.rfind("\\") + 1
data_path = data_path[0:last_index]

# convert model to float16
model_path = data_path+'\\models\\esrgan.onnx'
modelfp16_path = data_path+'\\models\\esrgan_float16.onnx'

model = onnx.load(model_path)
model_fp16 = float16.convert_float_to_float16(model)
onnx.save(model_fp16, modelfp16_path)