//+------------------------------------------------------------------+
//|                                                 TrailingNP.mqh |
//|                             Copyright 2000-2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertTrailing.mqh>
#include <my\Cnewton.mqh>
// wizard description start
//+----------------------------------------------------------------------+
//| Description of the class                                             |
//| Title=Trailing Stop based on newton's polyomial                      |
//| Type=Trailing                                                        |
//| Name=NP                                                            |
//| Class=CTrailingNP                                                  |
//| Page=                                                                |
//| Parameter=StopLevel,double,0.5,Stop Loss trailing Fraction           |
//| Parameter=Length,int,5,Length                                        |
//+----------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CTrailingNP.                                             |
//| Purpose: Class of trailing stops with newton's polyomial.          |
//|              Derives from class CExpertTrailing.                 |
//+------------------------------------------------------------------+
class CTrailingNP : public CExpertTrailing
{
protected:
   double                              m_stop_level;


   int                                 m_length;
   Cnewton                             __N;

public:
                     CTrailingNP(void);
                    ~CTrailingNP(void);
   //--- methods of initialization of protected data
   void              StopLevel(double stop_level)
   {  m_stop_level = stop_level;
   }
   void              Length(int value)
   {  m_length = value;
   };

   virtual bool      ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //---
   virtual bool      CheckTrailingStopLong(CPositionInfo *position, double &sl, double &tp);
   virtual bool      CheckTrailingStopShort(CPositionInfo *position, double &sl, double &tp);

};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CTrailingNP::CTrailingNP(void) : m_stop_level(0.5),
   m_length(5)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_HIGH+USE_SERIES_LOW;
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CTrailingNP::~CTrailingNP(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CTrailingNP::ValidationSettings(void)
{  if(!CExpertTrailing::ValidationSettings())
      return(false);
//--- initial data checks
   if(m_stop_level <= 0.0)
   {  printf(__FUNCTION__ + ": trailing Stop Level must be 0 or greater than %d", m_symbol.StopsLevel());
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CTrailingNP::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertTrailing::InitIndicators(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Checking trailing stop and/or profit for long position.          |
//+------------------------------------------------------------------+
bool CTrailingNP::CheckTrailingStopLong(CPositionInfo *position, double &sl, double &tp)
{
//--- check
   if(position == NULL)
      return(false);
   if(m_stop_level == 0.0)
      return(false);
//---
   double delta;
   double pos_sl = position.StopLoss();
   double base  = (pos_sl == 0.0) ? position.PriceOpen() : pos_sl;
   double price = m_symbol.Bid();
//---
   m_high.Refresh(-1);
   m_low.Refresh(-1);
   vector _x, _y;
   _x.Init(m_length);
   _y.Init(m_length);
   for(int i = 0; i < m_length; i++)
   {  _x[i] = i;
      _y[i] = (m_high.GetData(StartIndex()+i)-m_low.GetData(StartIndex()+i));
   }
   vector _w;
   _w.Init(m_length);
   _w[0] = _y[0];
   __N.Set(_w, _x, _y);
   double _xx = -1.0;
   double _yy = 0.0;
   __N.Get(_w, _x, _xx, _yy);
//---
   sl = EMPTY_VALUE;
   tp = EMPTY_VALUE;
   delta = (m_stop_level * _yy) + (m_symbol.Point() * m_symbol.StopsLevel());
//---
   if(price - base > delta)
   {  sl = price - delta;
   }
//---
   return(sl != EMPTY_VALUE);
}
//+------------------------------------------------------------------+
//| Checking trailing stop and/or profit for short position.         |
//+------------------------------------------------------------------+
bool CTrailingNP::CheckTrailingStopShort(CPositionInfo *position, double &sl, double &tp)
{
//--- check
   if(position == NULL)
      return(false);
   if(m_stop_level == 0.0)
      return(false);
//---
   double delta;
   double pos_sl = position.StopLoss();
   double base  = (pos_sl == 0.0) ? position.PriceOpen() : pos_sl;
   double price = m_symbol.Ask();
//---
   m_high.Refresh(-1);
   m_low.Refresh(-1);
   vector _x, _y;
   _x.Init(m_length);
   _y.Init(m_length);
   for(int i = 0; i < m_length; i++)
   {  _x[i] = i;
      _y[i] = (m_high.GetData(StartIndex()+i)-m_low.GetData(StartIndex()+i));
   }
   vector _w;
   _w.Init(m_length);
   _w[0] = _y[0];
   __N.Set(_w, _x, _y);
   double _xx = -1.0;
   double _yy = 0.0;
   __N.Get(_w, _x, _xx, _yy);
//---
   sl = EMPTY_VALUE;
   tp = EMPTY_VALUE;
   delta = (m_stop_level * _yy) + (m_symbol.Point() * m_symbol.StopsLevel());
//---
   if(base - price > delta)
   {  sl = price + delta;
   }
//---
   return(sl != EMPTY_VALUE);
}
//+------------------------------------------------------------------+
