//+------------------------------------------------------------------+
//|                                                     SignalWZ.mqh |
//|                   Copyright 2009-2017, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#include <my\Cnewton.mqh>
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on newton's polyomial                        |
//| Type=SignalAdvanced                                              |
//| Name=NP                                                          |
//| ShortName=NP                                                     |
//| Class=CSignalNP                                                  |
//| Page=signal_np                                                   |
//| Parameter=Length,int,5,Length                                    |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalNP.                                                 |
//| Purpose: Class of of trade signals based on newton's polyomial   |
//|            Derives from class CExpertSignal.                     |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CSignalNP                       : public CExpertSignal
{
protected:

   int                                 m_length;
   Cnewton                             __N;

public:

   //--- method of verification of settings
   virtual bool                        ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool                        InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int                         LongCondition(void);
   virtual int                         ShortCondition(void);

   void                                Length(int value)
   {  m_length = value;
   };

   double                              Solvability(vector &V);

                     CSignalNP(void);
                    ~CSignalNP(void);

};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CSignalNP::CSignalNP(void)  : m_length(5)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_SPREAD + USE_SERIES_TIME;
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalNP::ValidationSettings(void)
{  if(!CExpertSignal::ValidationSettings())
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalNP::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalNP::LongCondition(void)
{  int _result = 0;
   vector _x, _y;
   _x.Init(m_length);
   for(int i = 0; i < m_length; i++)
   {  _x[i] = i;
   }
   _y.Init(m_length);
   _y.CopyRates(m_symbol.Name(), m_period, 8, 0, m_length);
   vector _w;
   _w.Init(m_length);
   _w[0] = _y[0];
   __N.Set(_w, _x, _y);
   double _xx = -1.0;//m_length + 1.0, 
   double _yy = 0.0;
   __N.Get(_w, _x, _xx, _yy);
   //
   m_high.Refresh(-1);
   m_low.Refresh(-1);
   m_close.Refresh(-1);
   int _i = StartIndex();
   double _h = m_high.GetData(_i);
   double _l = m_low.GetData(_i);
   double _c = m_close.GetData(0);
   //
   if(_yy > _c)
   {  _result = int(round(((_yy-_c)/(fmax(_h,fmax(_yy,_c))-fmin(fmin(_yy,_c),_l))) * 100.0));
   }
   //
   return(_result);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalNP::ShortCondition(void)
{  int _result = 0;
   vector _x, _y;
   _x.Init(m_length);
   for(int i = 0; i < m_length; i++)
   {  _x[i] = i;
   }
   _y.Init(m_length);
   _y.CopyRates(m_symbol.Name(), m_period, 8, 0, m_length);
   vector _w;
   _w.Init(m_length);
   _w[0] = _y[0];
   __N.Set(_w, _x, _y);
   double _xx = -1.0;//m_length + 1.0, 
   double _yy = 0.0;
   __N.Get(_w, _x, _xx, _yy);
   //
   m_high.Refresh(-1);
   m_low.Refresh(-1);
   m_close.Refresh(-1);
   int _i = StartIndex();
   double _h = m_high.GetData(_i);
   double _l = m_low.GetData(_i);
   double _c = m_close.GetData(0);
   //
   if(_yy < _c)
   {  _result = int(round(((_c-_yy)/(fmax(_h,fmax(_yy,_c))-fmin(fmin(_yy,_c),_l))) * 100.0));
   }
   //
   return(_result);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CSignalNP::~CSignalNP(void)
{
}
//+------------------------------------------------------------------+
