//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property indicator_chart_window
#property indicator_plots 0
//+------------------------------------------------------------------+
#include <Canvas\Canvas.mqh>
//+------------------------------------------------------------------+
#define def_Limit   10.0
#define def_Step    0.1
//+------------------------------------------------------------------+
CCanvas *canvas;
//+------------------------------------------------------------------+
struct st_00
{
    int     x,
            y,
            maxX,
            maxY;
    double  Position;
}global;
//+------------------------------------------------------------------+
void PlotTextPosition(void)
{
    uint w, h;
    string sz0;

    sz0 = StringFormat("Position: [%.1f]", global.Position);
    TextGetSize(sz0, w, h);
    (*canvas).TextOut(global.x - (w / 2), global.maxY + 5, sz0, ColorToARGB(clrBlack)); 
}
//+------------------------------------------------------------------+
void Function_Curve(void)
{
    int x[], y[], d[];
    uint p;
    double fx, step;
    
    ArrayResize(x, (int)(((def_Limit * 2) / def_Step) + 1));
    ArrayResize(y, x.Size());
    ArrayResize(d, x.Size());

    step = MathMin(global.maxY, global.maxX) / (x.Size() * 1.0) / def_Step;

    fx = -def_Limit;
    for (uint c = 0, m = x.Size(); c < m; c++, fx += def_Step)
    {
        p = (fx <= global.Position ? c : p);
        x[c] = global.x + (int)(step * fx);
        y[c] = global.y - (int)(step * MathMax(0, fx));
        d[c] = global.y - (int)(step * (fx <= 0 ? 0 : 1));
    }

    (*canvas).PolylineThick(x, y, ColorToARGB(clrIndigo, 255), 3, STYLE_SOLID, LINE_END_ROUND);
    (*canvas).PolylineThick(x, d, ColorToARGB(clrDarkOrange, 255), 3, STYLE_SOLID, LINE_END_ROUND);

    (*canvas).FillCircle(x[p], y[p], 5, ColorToARGB(clrForestGreen, 255));
    (*canvas).FillCircle(x[p], d[p], 5, ColorToARGB(clrFireBrick, 255));

    ArrayFree(d);
    ArrayFree(y);
    ArrayFree(x);
}
//+------------------------------------------------------------------+
void UpdateGraphics(int direct)
{
    double value = global.Position + def_Step * direct;

    global.Position = MathAbs(value) <= def_Limit ? value : global.Position;

	(*canvas).Erase(ColorToARGB(clrWhite, 255));

    (*canvas).LineVertical(global.x, 0, global.maxY, ColorToARGB(clrRoyalBlue, 255));
    (*canvas).LineHorizontal(0, global.maxX, global.y, ColorToARGB(clrRoyalBlue, 255));

    PlotTextPosition();
    Function_Curve();

	(*canvas).Update(true);
}
//+------------------------------------------------------------------+
void Resize(void)
{
    uint w, h;
   
	global.maxX = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS, 0);
	global.maxY = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS, 0);

    if (canvas != NULL)
    {
        (*canvas).Destroy();
        delete canvas;
    }
    canvas = new CCanvas;
    (*canvas).CreateBitmapLabel("BL", 0, 0, global.maxX, global.maxY, COLOR_FORMAT_ARGB_NORMALIZE);
    global.x = global.maxX / 2;
    global.y = global.maxY / 2;
    TextGetSize("M", w, h);
    global.maxY -= (int)(h * 2);
}
//+------------------------------------------------------------------+
int OnInit()
{		
    ZeroMemory(global);
    canvas = NULL;

	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
	return rates_total;
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
    int direct = 0;

    switch (id)
    {
        case CHARTEVENT_CHART_CHANGE:
            Resize();
            break;
        case CHARTEVENT_KEYDOWN:
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_LEFT)) direct = -1;
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_RIGHT)) direct = 1;
            break;
    }
    UpdateGraphics(direct);
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	(*canvas).Destroy();
    delete canvas;
}
//+------------------------------------------------------------------+