//+------------------------------------------------------------------+
//|                                       RandomStationarySeries.mqh |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include<Math\Stat\Normal.mqh>
#include<Math\Stat\Math.mqh>

//+------------------------------------------------------------------+
//|Series with obvious level change                                  |
//+------------------------------------------------------------------+
bool level_change_series(uint len, uint level, double &out_series[])
  {
   if(len<10 || !level)
      return false;

   ArrayResize(out_series,int(len));

   double upper_level = double(level),lower_level=-1.0*double(level);

   for(uint i = 0; i<len/2; i++)
     {
      out_series[i]=lower_level*MathRandomNonZero();
      out_series[len-1-i]=(lower_level*MathRandomNonZero())+(upper_level*2);
     }

   return true;
  }
//+------------------------------------------------------------------+
//| Generate series with brief periodic component                    |
//+------------------------------------------------------------------+
bool brief_periodic_series(uint len, double frequency, double &out_series[])
  {
   if(len<10 || frequency<=0)
      return false;

   double time[];

   if(!MathSequenceByCount(0.0,10.0,int(len),time))
      return false;

   ArrayResize(out_series,int(len));

   for(uint i = 0; i<len; i++)
     {
      out_series[i]=(i<uint(len/4) || i>=uint(len*0.75))?0.0:MathSin(2*M_PI*time[i]*frequency);
     }

   return true;
  }
//+------------------------------------------------------------------+
//| Generates random stationary series                               |
//+------------------------------------------------------------------+
bool random_stationary_series(uint len, double mean, double variance,double &out_series[])
  {
   if(len<10)
      return false;

   if(!MathRandomNormal(mean,variance,int(len),out_series))
     {
      Print("MathRandomNormal error ", GetLastError());
      return false;
     }

   return(MathCumulativeSum(out_series));
  }
//+------------------------------------------------------------------+
//| Generates random non stationary series                           |
//+------------------------------------------------------------------+
bool random_nonstationary_series(uint len, double &out_series[])
  {
   if(MathMod(len,10))
      len += (10 - uint(MathMod(len,10)));

   uint mult = len/10;

   if(mult<10)
     {
      mult=10;
      len = mult*10;
     }


   ArrayResize(out_series,len);
   double temp[];
   for(int i = 0; i<10; i++)
     {
      if(!random_stationary_series(mult,double(MathRand()/MathRand()),MathRandomNonZero(),temp))
         return false;
      ArrayCopy(out_series,temp,i*mult,0);
     }

   for(uint i = 0; i<out_series.Size(); i++)
     {
      out_series[i]=sin(2*M_PI*(double(out_series[i])/double(out_series.Size())));
     }

   return true;
  }
//+------------------------------------------------------------------+
