//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property indicator_chart_window
#property indicator_plots 0
//+------------------------------------------------------------------+
#include <Canvas\Canvas.mqh>
//+------------------------------------------------------------------+
#define _ToRadians(A) (A * (M_PI / 180.0))
#define _SizeLine 200
//+------------------------------------------------------------------+
CCanvas canvas;
//+------------------------------------------------------------------+
struct st_00
{
    int     x,
            y;
    double  Angle,
            Const_B;
}global;
//+------------------------------------------------------------------+
void Straight_Function(const double &Infos[], double &Ret[])
{
    double M[], T[4], Det;
    uint n = (uint)(Infos.Size() / 2);

    if (!ArrayIsDynamic(Ret))
    {
        Print("Response array must be of the dynamic type...");
        Det = (1 / MathAbs(0));
    }
    ArrayResize(M, Infos.Size());
    M[0] = M[1] = 0;
    M[3] = (double)(n);
    for (uint c = 0; c < n; c++)
    {
        M[0] += (Infos[c * 2] * Infos[c * 2]);
        M[2] = (M[1] += Infos[c * 2]);
    }
    Det = (M[0] * M[3]) - (M[1] * M[2]);
    T[0] = M[3] / Det;
    T[1] = T[2] = -(M[1] / Det);
    T[3] = M[0] / Det;
    ZeroMemory(M);
    for (uint c = 0; c < n; c++)
    {
        M[(c * 2) + 0] = (Infos[c * 2] * T[0]) + T[1];
        M[(c * 2) + 1] = (Infos[c * 2] * T[2]) + T[3];
    }
    ArrayResize(Ret, 2);
    ZeroMemory(Ret);
    for (uint c = 0; c < n; c++)
    {
        Ret[0] += (Infos[(c * 2) + 1] * M[(c * 2) + 0]);
        Ret[1] += (Infos[(c * 2) + 1] * M[(c * 2) + 1]);
    }
}
//+------------------------------------------------------------------+
matrix Matrix_PInv(const double &A[])
{
    double M[], T[4], Det;

    ArrayResize(M, A.Size() * 2);
    M[0] = M[1] = 0;
    M[3] = (double)A.Size();
    for (uint c = 0; c < M[3]; c++)
    {
        M[0] += (A[c] * A[c]);
        M[2] = (M[1] += A[c]);
    }
    Det = (M[0] * M[3]) - (M[1] * M[2]);
    T[0] = M[3] / Det;
    T[1] = T[2] = -(M[1] / Det);
    T[3] = M[0] / Det;
    ZeroMemory(M);
    for (uint c = 0; c < A.Size(); c++)
    {
        M[(c * 2) + 0] = (A[c] * T[0]) + T[1];
        M[(c * 2) + 1] = (A[c] * T[2]) + T[3];
    }

    matrix Ret;
    Ret.Init(A.Size(), 2);
    for (uint c = 0; c < A.Size(); c++)
    {
        Ret[c][0] = M[(c * 2) + 0];
        Ret[c][1] = M[(c * 2) + 1];
    }

    return Ret;
}
//+------------------------------------------------------------------+
void PlotText(const uchar line, const string sz0, const color cor = clrBlack)
{
    uint w, h;

    TextGetSize(sz0, w, h);
    canvas.TextOut(global.x - (w / 2), global.y + _SizeLine + (line * h) + 5, sz0, ColorToARGB(cor));   
}
//+------------------------------------------------------------------+
void Func_01(void)
{
    double Bank[]
    {
        -100, -150,
        -80,  -50,
        30,   80,
        100,  120
    };
    int vx, vy;
    double ly, err, Ret[];
    string s0 = "";

    canvas.LineVertical(global.x, global.y - _SizeLine, global.y + _SizeLine, ColorToARGB(clrRoyalBlue, 255));
    canvas.LineHorizontal(global.x - _SizeLine, global.x + _SizeLine, global.y, ColorToARGB(clrRoyalBlue, 255));

    err = 0;
    for (uint c0 = 0, c1 = 0; c1 < Bank.Size(); c0++)
    {
        vx = (int)Bank[c1++];
        vy = (int)Bank[c1++];
	    canvas.FillCircle(global.x + vx, global.y - vy, 5, ColorToARGB(clrRed, 255));
        ly = vy - (vx * -MathTan(_ToRadians(global.Angle))) - global.Const_B;
        s0 += StringFormat("%.4f || ", MathAbs(ly));
        canvas.LineVertical(global.x + vx, global.y - vy, global.y + (int)(ly - vy), ColorToARGB(clrPurple));
        err += MathPow(ly, 2);
    }
    PlotText(3, StringFormat("Error: %.8f", err), clrFireBrick);
    PlotText(4, s0);
    Straight_Function(Bank, Ret);
    PlotText(5, StringFormat("f(x) = %.8fx %c %.8f", Ret[0], (Ret[1] < 0 ? '-' : '+'), MathAbs(Ret[1])), clrForestGreen);
}
//+------------------------------------------------------------------+
void NewAngle(const char direct, const char updow, const double step = 0.1)
{
	canvas.Erase(ColorToARGB(clrWhite, 255));

    global.Angle = (MathAbs(global.Angle + (step * direct)) < 90 ? global.Angle + (step * direct) : global.Angle);
    global.Const_B += (step * updow);  
    PlotText(1, StringFormat("Angle in graus => %.2f", MathAbs(global.Angle)));
    PlotText(2, StringFormat("f(x) = %.4fx %c %.4f", -MathTan(_ToRadians(global.Angle)), (global.Const_B < 0 ? '-' : '+'), MathAbs(global.Const_B)), clrPurple);
    canvas.LineAA(
                global.x - (int)(_SizeLine * cos(_ToRadians(global.Angle))), 
                (global.y - (int)global.Const_B) - (int)(_SizeLine * sin(_ToRadians(global.Angle))), 
                global.x + (int)(_SizeLine * cos(_ToRadians(global.Angle))), 
                (global.y - (int)global.Const_B) + (int)(_SizeLine * sin(_ToRadians(global.Angle))), 
                ColorToARGB(clrForestGreen)
            );
   	
    Func_01();

	canvas.Update(true);
}
//+------------------------------------------------------------------+
int OnInit()
{
    ZeroMemory(global);
	global.x = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS, 0);
	global.y = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS, 0);

	canvas.CreateBitmapLabel("BL", 0, 0, global.x, global.y, COLOR_FORMAT_ARGB_NORMALIZE);
    global.x /= 2;
    global.y /= 2;

    NewAngle(0, 0);

	canvas.Update(true);

	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
	return rates_total;
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
    switch (id)
    {
        case CHARTEVENT_KEYDOWN:
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_LEFT))
                NewAngle(-1, 0);
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_RIGHT))
                NewAngle(1, 0);
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_PAGEUP))
                NewAngle(0, 1);
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_PAGEDOWN))
                NewAngle(0, -1);
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_UP))
                NewAngle(0, 1, 0.01);
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_DOWN))
                NewAngle(0, -1, 0.01);
            break;
    }
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	canvas.Destroy();
}
//+------------------------------------------------------------------+