//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define macroRandom (rand() / (double)SHORT_MAX)
//+------------------------------------------------------------------+
double Train[][2] {
                    {-100, -150},
                    { -80,  -50},
                    {  30,   80},
                    { 100,  120},
                  };
//+------------------------------------------------------------------+
const uint nTrain = Train.Size() / 2;
const double eps = 1e-3;
//+------------------------------------------------------------------+
double Cost(const double w, const double b)
{
    double err, fx, a;

    err = 0;
    for (uint c = 0; c < nTrain; c++)
    {
        a = Train[c][0];
        fx =  a * w + b;
        err += MathPow(fx - Train[c][1], 2);
    }

    return err / nTrain;
}
//+------------------------------------------------------------------+
void OnStart()
{
    double weight, ew, eb, e1, bias;

    Print("The first neuron...");
    MathSrand(512);
    weight = (double)macroRandom;
    bias = (double)macroRandom;

    for(ulong c = 0; (c < 5) && ((e1 = Cost(weight, bias)) > eps); c++)
    {
        ew = (Cost(weight + eps, bias) - e1) / eps;
        eb = (Cost(weight, bias + eps) - e1) / eps;
        weight -= (ew * eps);
        bias -= (eb * eps);
        PrintFormat("%I64u > w0: %.4f %.4f || b: %.4f %.4f", c, weight, ew, bias, eb);
    }
    Print("Weight: ", weight);
}