//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define PrintEx(A) Print(#A, " => ", A)
#define macroRandom (rand() / (double)SHORT_MAX)
//+------------------------------------------------------------------+
double Train[][2] {
                    {0, 0},
                    {1, 3},
                    {2, 6},
                    {3, 9},
                    {4, 12},
                  };
//+------------------------------------------------------------------+
const uint nTrain = Train.Size() / 2;
const double epsilon = 1e-3;
//+------------------------------------------------------------------+
struct stErr
{
    double  Weight,
            Bias;
};
//+------------------------------------------------------------------+
stErr Cost(const double w, const double b)
{
    double x, y, t;
    stErr err;

    ZeroMemory(err);
    for (uint c = 0; c < nTrain; c++)
    {
        x = Train[c][0];
        y = Train[c][1];
        t = 2 * ((x * w + b) - y);
        err.Weight += (t * x);
        err.Bias += t;
    }

    return err;
}
//+------------------------------------------------------------------+
void OnStart()
{
    double weight, bias;
    ulong it0, it1, count;
    stErr err;

    Print("************************************");
    Print("Gradient Descent Neuron...");
    MathSrand(512);
    weight = (double)macroRandom;
    bias = (double)macroRandom;

    it0 = GetTickCount();
    for(count = 0; count < ULONG_MAX; count++)
    {
        err = Cost(weight, bias);
        if ((MathAbs(err.Weight) <= epsilon) && (MathAbs(err.Bias) <= epsilon))
            break;
        weight -= (err.Weight * epsilon);
        bias -= (err.Bias * epsilon);
    }
    it1 = GetTickCount();
    Print("Time: ", (it1 - it0) / 1000.0, " seconds.");
    PrintEx(count);
    PrintEx(weight);
    PrintEx(bias);
    PrintEx(err.Weight);
    PrintEx(err.Bias);
}
//+------------------------------------------------------------------+