//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define PrintEx(A) Print(#A, " => ", A)
#define macroRandom (rand() / (double)SHORT_MAX)
//+------------------------------------------------------------------+
double Train[][2] {
                    {0, 0},
                    {1, 3},
                    {2, 6},
                    {3, 9},
                    {4, 12},
                  };
//+------------------------------------------------------------------+
const uint nTrain = Train.Size() / 2;
const double epsilon = 1e-3;
//+------------------------------------------------------------------+
double Cost(const double w)
{
    double err, factor;

    err = 0;
    for (uint c = 0; c < nTrain; c++)
    {
        factor = Train[c][0] * w;
        err += MathPow(factor - Train[c][1], 2);
    }

    return err;
}
//+------------------------------------------------------------------+
void OnStart()
{
    double weight, err, e1;
    ulong it0, it1, count;

    Print("************************************");
    Print("Linear regression neuron...");
    MathSrand(512);
    weight = (double)macroRandom;

    it0 = GetTickCount();
    for(count = 0; (count < ULONG_MAX) && ((err = Cost(weight)) > epsilon); count++)
    {
        e1 = (Cost(weight + epsilon) - err) / epsilon;
        weight -= (e1 * epsilon);
    }
    it1 = GetTickCount();
    Print("Time: ", (it1 - it0) / 1000.0, " seconds.");
    PrintEx(count);
    PrintEx(weight);
    PrintEx(err);
}
//+------------------------------------------------------------------+